/*
 * Decompiled with CFR 0.152.
 */
package de.jave.ascii.plate.textareabased;

import de.jave.ascii.IAsciiGuiConstants;
import de.jave.ascii.plate.ruler.AsciiRulerProperties;
import java.awt.Color;
import java.awt.Font;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.swing.fontchooser.model.FontModel;

public final class AsciiTextAreaProperties
extends AbstractChangeableModel {
    private boolean editable = true;
    private final FontModel fontModel;
    private Color backgroundColor = Color.WHITE;
    private Color foregroundColor = Color.BLACK;
    private final AsciiRulerProperties rulerProperties;

    public AsciiTextAreaProperties() {
        this(new FontModel(IAsciiGuiConstants.DEFAULT_ASCII_FONT));
    }

    public AsciiTextAreaProperties(FontModel fontModel) {
        fontModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AsciiTextAreaProperties.this.fireChangeEvent();
            }
        });
        this.fontModel = fontModel;
        this.rulerProperties = new AsciiRulerProperties(fontModel);
    }

    public final Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public final Color getForegroundColor() {
        return this.foregroundColor;
    }

    public final boolean isEditable() {
        return this.editable;
    }

    public final void setEditable(boolean editable) {
        if (this.editable == editable) {
            return;
        }
        this.editable = editable;
        this.fireChangeEvent();
    }

    public final Font getFont() {
        return this.fontModel.getFont();
    }

    public final AsciiRulerProperties getRulerProperties() {
        return this.rulerProperties;
    }
}

