/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.action;

import de.jave.asciimation.JmovFileChooserConfiguration;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.jave.Jave;
import de.jave.jave.actions.AbstractJaveAction;
import de.jave.jave.actions.enablestrategy.AlwaysEnabledStrategy;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.plate.IDocumentEditor;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.javeplayer.JaveAnimationFile;
import java.awt.Component;
import java.io.File;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class OpenAnimationAction
extends AbstractJaveAction {
    private final FileModel currentDirectoryModel;
    private final Jave jave;

    public OpenAnimationAction(JaveMainPanel mainPanel, Jave jave, FileModel currentDirectoryModel) {
        super(mainPanel, "Open...", JaveImageProvider.getInstance().getImageIcon("open.gif"));
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        Ensure.ensureArgumentNotNull(jave);
        this.currentDirectoryModel = currentDirectoryModel;
        this.jave = jave;
    }

    protected final IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return AlwaysEnabledStrategy.getInstance();
    }

    protected final void ececute(Component parentComponent, IDocumentEditor editor) {
        File file = FileChooserUtilities.performOpenFileChooserOLD(parentComponent, new JmovFileChooserConfiguration(this.currentDirectoryModel));
        if (file == null) {
            return;
        }
        this.jave.open(parentComponent, file);
    }

    public static final JaveAnimationFile open(File file, Component parentComponent) {
        JaveAnimationFile newFile = new JaveAnimationFile(file);
        try {
            newFile.load(file.toURL());
        }
        catch (Exception e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE Animation Editor", "Error loading file", e));
            return null;
        }
        return newFile;
    }
}

