/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.editor;

import de.jave.asciimation.editor.AnimationEditorModel;
import de.jave.asciimation.editor.AnimationEditorPopupMenuFactory;
import de.jave.jave.AsciiToThumbnailConverter;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.lib.CharacterPlate;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.ListSelectionModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.disy.commons.core.util.Ensure;

public final class AnimationThumbnailsPanel
extends JComponent {
    private static final Dimension THUMBNAIL_SIZE = new Dimension(100, 60);
    private final AnimationEditorModel model;

    public AnimationThumbnailsPanel(final AnimationEditorModel model) {
        Ensure.ensureArgumentNotNull(model);
        this.model = model;
        MouseAdapter mouseListener = new MouseAdapter(){

            public final void mousePressed(MouseEvent evt) {
                int frameIndex = AnimationThumbnailsPanel.this.getFrameAt(evt.getPoint());
                if (frameIndex >= 0 && frameIndex < AnimationThumbnailsPanel.this.model.getAnimationFile().getFrameCount()) {
                    ListSelectionModel selectionModel = AnimationThumbnailsPanel.this.model.getFrameSelectionModel();
                    if (evt.isMetaDown()) {
                        if (!selectionModel.isSelectedIndex(frameIndex)) {
                            selectionModel.setSelectionInterval(frameIndex, frameIndex);
                        }
                        JPopupMenu menu = AnimationEditorPopupMenuFactory.createFramePopupMenu(model);
                        menu.show(AnimationThumbnailsPanel.this, evt.getX(), evt.getY());
                        return;
                    }
                    if (evt.isControlDown()) {
                        if (selectionModel.isSelectedIndex(frameIndex)) {
                            selectionModel.removeSelectionInterval(frameIndex, frameIndex);
                            return;
                        }
                        selectionModel.addSelectionInterval(frameIndex, frameIndex);
                        return;
                    }
                    selectionModel.setSelectionInterval(frameIndex, frameIndex);
                }
            }

            public final void mouseClicked(MouseEvent evt) {
                int frameIndex;
                if (evt.getClickCount() == 2 && (frameIndex = AnimationThumbnailsPanel.this.getFrameAt(evt.getPoint())) >= 0 && frameIndex < AnimationThumbnailsPanel.this.model.getAnimationFile().getFrameCount()) {
                    AnimationThumbnailsPanel.this.model.getCurrentFrameIndexModel().setCurrentFrameIndex(frameIndex);
                }
            }
        };
        this.addMouseListener(mouseListener);
        this.setBackground(Color.black);
        model.getFrameSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public final void valueChanged(ListSelectionEvent e) {
                AnimationThumbnailsPanel.this.repaint();
            }
        });
        model.getCurrentFrameIndexModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AnimationThumbnailsPanel.this.repaint();
            }
        });
        model.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AnimationThumbnailsPanel.this.repaint();
            }
        });
    }

    public final JComponent getContent() {
        return this;
    }

    public final Dimension getPreferredSize() {
        return new Dimension(AnimationThumbnailsPanel.THUMBNAIL_SIZE.width * 3, AnimationThumbnailsPanel.THUMBNAIL_SIZE.height);
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected final void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, size.width, size.height);
        int centerX = size.width / 2;
        int currentIndex = this.model.getCurrentFrameIndexModel().getCurrentFrameIndex();
        int startIndex = currentIndex - (int)Math.ceil((double)(centerX - AnimationThumbnailsPanel.THUMBNAIL_SIZE.width / 2) / (double)AnimationThumbnailsPanel.THUMBNAIL_SIZE.width);
        int endIndex = currentIndex + (int)Math.ceil((double)(centerX - AnimationThumbnailsPanel.THUMBNAIL_SIZE.width / 2) / (double)AnimationThumbnailsPanel.THUMBNAIL_SIZE.width);
        for (int frameIndex = startIndex; frameIndex <= endIndex; ++frameIndex) {
            Image image = this.createThumbnailImage(frameIndex);
            if (image == null) continue;
            Rectangle rectangle = this.getFrameBounds(frameIndex);
            Rectangle imageBounds = new Rectangle(rectangle.x + (rectangle.width - image.getWidth(null)) / 2, rectangle.y + (rectangle.height - image.getHeight(null)) / 2, image.getWidth(null), image.getHeight(null));
            g.drawImage(image, imageBounds.x, imageBounds.y, imageBounds.width, imageBounds.height, null);
            if (!this.model.getFrameSelectionModel().isSelectedIndex(frameIndex)) continue;
            g.setColor(Color.black);
            g.setXORMode(SystemColor.textHighlight);
            g.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            g.setPaintMode();
        }
    }

    private Image createThumbnailImage(int frameIndex) {
        JaveAnimationFrame frame = this.getFrameIfInRange(frameIndex);
        if (frame == null) {
            return null;
        }
        char[][] chContent = frame.getContent();
        CharacterPlate content = new CharacterPlate(chContent);
        char[][] chSelection = frame.getSelection();
        if (chSelection != null) {
            new CharacterPlate(chSelection).pasteInto(content, frame.getSelectionX(), frame.getSelectionY());
        }
        Color bg = this.model.getAnimationFile().getProperties().getBackgroundColor();
        Color fg = this.model.getAnimationFile().getProperties().getForegroundColor();
        BufferedImage image = AsciiToThumbnailConverter.ascii2ImageQuick(content, 2, bg, fg);
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight() * 2;
        double scaleX = (double)(AnimationThumbnailsPanel.THUMBNAIL_SIZE.width - 4) / (double)imageWidth;
        double scaleY = (double)(AnimationThumbnailsPanel.THUMBNAIL_SIZE.height - 4) / (double)imageHeight;
        double scale = Math.min(scaleX, scaleY);
        int newWidth = (int)((double)imageWidth * scale);
        int newHeight = (int)((double)imageHeight * scale);
        return image.getScaledInstance(newWidth, newHeight, 4);
    }

    private Rectangle getFrameBounds(int frameIndex) {
        Dimension size = this.getSize();
        int x = (frameIndex - this.model.getCurrentFrameIndexModel().getCurrentFrameIndex()) * AnimationThumbnailsPanel.THUMBNAIL_SIZE.width + size.width / 2 - AnimationThumbnailsPanel.THUMBNAIL_SIZE.width / 2;
        boolean y = false;
        int width = AnimationThumbnailsPanel.THUMBNAIL_SIZE.width;
        int height = size.height;
        return new Rectangle(x, 0, width, height);
    }

    private int getFrameAt(Point point) {
        int currentIndex = this.model.getCurrentFrameIndexModel().getCurrentFrameIndex();
        int offset = point.x - (this.getSize().width / 2 - AnimationThumbnailsPanel.THUMBNAIL_SIZE.width / 2);
        if (offset >= 0) {
            return currentIndex + offset / AnimationThumbnailsPanel.THUMBNAIL_SIZE.width;
        }
        return currentIndex + offset / AnimationThumbnailsPanel.THUMBNAIL_SIZE.width - 1;
    }

    private JaveAnimationFrame getFrameIfInRange(int index) {
        JaveAnimationFile animationFile = this.model.getAnimationFile();
        if (index < 0 || index >= animationFile.getFrameCount()) {
            return null;
        }
        return animationFile.getFrame(index);
    }
}

