/*
 * Decompiled with CFR 0.152.
 */
package de.jave.asciimation.export;

import de.jave.asciimation.export.AnimationExportOptions;
import de.jave.asciimation.export.IAnimationExporter;
import de.jave.javeplayer.AnimationProperties;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.javeplayer.JaveAnimationFrame;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import java.awt.Dimension;
import java.lang.reflect.InvocationTargetException;
import net.disy.commons.core.exception.MessageException;
import net.disy.commons.core.message.Message;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.IRunnableWithProgress;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;
import net.disy.commons.swing.dialog.progress.ProgressMonitorDialog;

public final class AnimationFileExporter {
    public static final void performExport(Component parentComponent, final JaveAnimationFile animationFile, AnimationExportOptions options) {
        final IAnimationExporter exporter = options.getFormat().createExporter(options);
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(parentComponent, "JavE Animation Editor");
        try {
            dialog.run(true, new IRunnableWithProgress(){

                public final void run(IProgressMonitor monitor) throws InterruptedException, InvocationTargetException {
                    monitor.beginTask("Exporting " + animationFile.getFrameCount() + " frames...", animationFile.getFrameCount());
                    Dimension maxFrameSize = new Dimension(0, 0);
                    CharacterPlate content = null;
                    for (int i = 0; i < animationFile.getFrameCount(); ++i) {
                        ProgressUtilities.checkInterrupted(monitor);
                        JaveAnimationFrame frame = animationFile.getFrame(i);
                        content = new CharacterPlate(frame.getContent());
                        if (content.getWidth() > maxFrameSize.width) {
                            maxFrameSize.width = content.getWidth();
                        }
                        if (content.getHeight() <= maxFrameSize.height) continue;
                        maxFrameSize.height = content.getHeight();
                    }
                    try {
                        AnimationProperties properties = animationFile.getProperties();
                        exporter.init(maxFrameSize, properties, animationFile.getFrameCount(), animationFile.getMetaData());
                        for (int i = 0; i < animationFile.getFrameCount(); ++i) {
                            ProgressUtilities.checkInterrupted(monitor);
                            monitor.subTask("Writing frame " + (i + 1));
                            JaveAnimationFrame frame = animationFile.getFrame(i);
                            content = new CharacterPlate(frame.getContent());
                            char[][] chSelection = frame.getSelection();
                            if (chSelection != null) {
                                new CharacterPlate(chSelection).pasteInto(content, frame.getSelectionX(), frame.getSelectionY());
                            }
                            exporter.writeFrame(content);
                            monitor.worked(1);
                        }
                        exporter.finish();
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        InterruptedException e = interruptedException;
                        throw interruptedException;
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
            String message = "Export finished successfully.";
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE Animation Editor", message, MessageType.INFORMATION));
            return;
        }
        catch (InterruptedException interruptedException) {
            exporter.rollBack();
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE Animation Editor", "Export aborted.", MessageType.WARNING));
            return;
        }
        catch (InvocationTargetException e) {
            exporter.rollBack();
            if (e.getCause() instanceof OutOfMemoryError) {
                MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE Animation Editor", "Error exporting file: The result file is to big.", e.getCause()));
                return;
            }
            if (e.getCause() instanceof MessageException) {
                MessageDialogFactory.showMessageDialog(parentComponent, ((MessageException)e.getCause()).getMessageObject());
                return;
            }
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("JavE Animation Editor", "Error exporting file.", e.getCause()));
            return;
        }
    }
}

