/*
 * Decompiled with CFR 0.152.
 */
package de.jave.calculus;

import de.jave.calculus.ParseException;
import de.jave.calculus.SimpleNode;

public final class ASTFunctionNode
extends SimpleNode {
    protected int type;
    protected static final String[] NAMES = new String[]{"sin", "cos", "tan", "log", "min", "max", "abs", "floor", "ceil", "sqr", "sqrt", "sgn"};
    protected static final int[] ARGUMENTLENGTHS = new int[]{1, 1, 1, 1, 2, 2, 1, 1, 1, 1, 1, 1};

    public ASTFunctionNode(int id) {
        super(id);
    }

    public final void setFunctionName(String name) throws ParseException {
        for (int i = 0; i < NAMES.length; ++i) {
            if (!name.equalsIgnoreCase(NAMES[i])) continue;
            this.type = i;
            return;
        }
        throw new ParseException("No such function: '" + name + "'");
    }

    public final int getCorrectArgumentCount() {
        return ARGUMENTLENGTHS[this.type];
    }

    public final double evaluate(double x) throws Exception {
        switch (this.type) {
            case 0: {
                return Math.sin(this.jjtGetChild(0).evaluate(x));
            }
            case 1: {
                return Math.cos(this.jjtGetChild(0).evaluate(x));
            }
            case 2: {
                return Math.tan(this.jjtGetChild(0).evaluate(x));
            }
            case 3: {
                return Math.log(this.jjtGetChild(0).evaluate(x));
            }
            case 4: {
                return Math.min(this.jjtGetChild(0).evaluate(x), this.jjtGetChild(1).evaluate(x));
            }
            case 5: {
                return Math.max(this.jjtGetChild(0).evaluate(x), this.jjtGetChild(1).evaluate(x));
            }
            case 6: {
                return Math.abs(this.jjtGetChild(0).evaluate(x));
            }
            case 7: {
                return Math.floor(this.jjtGetChild(0).evaluate(x));
            }
            case 8: {
                return Math.ceil(this.jjtGetChild(0).evaluate(x));
            }
            case 9: {
                return Math.sqrt(this.jjtGetChild(0).evaluate(x));
            }
            case 10: {
                return Math.sqrt(this.jjtGetChild(0).evaluate(x));
            }
            case 11: {
                if (this.jjtGetChild(0).evaluate(x) >= 0.0) {
                    return 1.0;
                }
                return -1.0;
            }
        }
        throw new Exception("Illegal function type!");
    }
}

