/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet;

import de.jave.figlet.engine.FigDriver;
import de.jave.figlet.file.BaseFolderFigFileResource;
import de.jave.figlet.file.BaseUrlFigFileResource;
import de.jave.figlet.file.ClasspathFigFileResource;
import de.jave.figlet.file.FigFileLibrary;
import de.jave.figlet.file.IFigFileResource;
import de.jave.figlet.file.ZipFileFigFileResource;
import de.jave.figlet.util.FigException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import net.disy.commons.core.util.Ensure;

public class Figlet {
    private FigDriver driver;

    public Figlet() throws FigException {
        this(new ClasspathFigFileResource());
    }

    private static IFigFileResource createFigFileResource(String libraryLocation) throws FigException {
        if (libraryLocation == null || libraryLocation.length() == 0) {
            return new ClasspathFigFileResource();
        }
        if (libraryLocation.toLowerCase().startsWith("http:") || libraryLocation.toLowerCase().startsWith("file:")) {
            try {
                return new BaseUrlFigFileResource(new URL(libraryLocation));
            }
            catch (MalformedURLException exception) {
                throw new FigException("The given library location '" + libraryLocation + "' does not seem to be a valid URL", exception);
            }
        }
        return Figlet.createFigFileResource(new File(libraryLocation));
    }

    private static IFigFileResource createFigFileResource(File file) throws FigException {
        if (file.exists() && !file.isDirectory()) {
            return new ZipFileFigFileResource(file);
        }
        return new BaseFolderFigFileResource(file);
    }

    public Figlet(IFigFileResource fileResource) throws FigException {
        this.driver = new FigDriver(fileResource);
    }

    public String figletize(String text) throws FigException {
        return this.figletize(text, "standard");
    }

    public String figletize(String text, String fontName) throws FigException {
        Ensure.ensureArgumentNotNull(text);
        Ensure.ensureArgumentNotNull(fontName);
        return this.driver.figletize(text, fontName);
    }

    public String figletizeFigml(String figmlText) throws FigException {
        Ensure.ensureArgumentNotNull(figmlText);
        return this.driver.figml(figmlText);
    }

    public FigDriver getFigDriver() {
        return this.driver;
    }

    public FigFileLibrary getFileLibrary() {
        return this.getFigDriver().getFileLibrary();
    }
}

