/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.engine.primitives;

import de.jave.figlet.engine.layout.PrintDirection;
import de.jave.figlet.engine.primitives.FigLayout;
import de.jave.figlet.engine.primitives.HorizontalLayoutMode;
import de.jave.figlet.engine.primitives.HorizontalSmushingRules;
import de.jave.figlet.engine.primitives.VerticalLayoutMode;
import de.jave.figlet.engine.primitives.VerticalSmushingRules;

public final class FigLayoutEncoder {
    public final VerticalLayoutMode getVerticalLayoutMode(int layout) {
        if (FigLayoutEncoder.isSet(layout, 16384)) {
            return VerticalLayoutMode.SMUSHING;
        }
        if (FigLayoutEncoder.isSet(layout, 8192)) {
            return VerticalLayoutMode.VERTICAL_FITTING;
        }
        return VerticalLayoutMode.FULL_HEIGHT;
    }

    private static boolean isSet(int layout, int flag) {
        return (layout & flag) == flag;
    }

    public final HorizontalLayoutMode getHorizontalLayoutMode(int layout) {
        if (FigLayoutEncoder.isSet(layout, 128)) {
            return HorizontalLayoutMode.SMUSHING;
        }
        if (FigLayoutEncoder.isSet(layout, 64)) {
            return HorizontalLayoutMode.KERNING;
        }
        return HorizontalLayoutMode.FULL_WIDTH;
    }

    private FigLayout getLayout(int layout) {
        HorizontalLayoutMode horizontalMode = this.getHorizontalLayoutMode(layout);
        VerticalLayoutMode verticalMode = this.getVerticalLayoutMode(layout);
        HorizontalSmushingRules horizontalRules = new HorizontalSmushingRules(layout);
        VerticalSmushingRules verticalRules = new VerticalSmushingRules(layout);
        return new FigLayout(horizontalMode, horizontalRules, verticalMode, verticalRules);
    }

    public final FigLayout createFromOldLayoutValue(int oldLayout) {
        return this.createFromCombinedLayoutValues(oldLayout, -1);
    }

    public final FigLayout createFromCombinedLayoutValues(int oldLayout, int newLayout) {
        int layout = 0;
        layout = newLayout == -1 ? (oldLayout == -1 ? 0 : (oldLayout == 0 ? 64 : oldLayout | 0x80)) : newLayout;
        return this.getLayout(layout);
    }

    public final PrintDirection getPrintDirection(int i) {
        if (i == 0) {
            return PrintDirection.LEFT_TO_RIGHT;
        }
        if (i == 1) {
            return PrintDirection.RIGHT_TO_LEFT;
        }
        return null;
    }
}

