/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.application;

import de.jave.ascii.plate.ITextContentListener;
import de.jave.ascii.plate.textareabased.AsciiTextArea;
import de.jave.ascii.plate.textareabased.AsciiTextAreaProperties;
import de.jave.figlet.IFigLayoutListener;
import de.jave.figlet.IFontSelectionListener;
import de.jave.figlet.engine.FigDriver;
import de.jave.figlet.engine.layout.HorizontalAlignment;
import de.jave.figlet.engine.primitives.FigFont;
import de.jave.figlet.engine.primitives.FigLayout;
import de.jave.figlet.engine.processing.FigletJobFactory;
import de.jave.figlet.engine.processing.IFigletJob;
import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.swing.application.DimensionTextField;
import de.jave.figlet.swing.fontchooser.FontChooserView;
import de.jave.figlet.swing.layout.FigLayoutPanel;
import de.jave.figlet.swing.preferences.JFigletPreferences;
import de.jave.figlet.util.FigException;
import de.jave.figlet.util.FigUtilities;
import de.jave.lib.job.AsynchronousDroppingJobProcessor;
import de.jave.lib.job.IJobProcessor;
import de.jave.lib.job.JobProcessingContext;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.fontchooser.model.FontModel;

public final class JFigletEditor {
    private AsciiTextArea taOutput;
    private AsciiTextArea taInput;
    private AsynchronousDroppingJobProcessor processor;
    private FontChooserView fontChooser;
    private FigLayoutPanel layoutPanel;
    private JTextField statusBar;
    private DimensionTextField sizeBar;
    private FigDriver figDriver;
    private final JComponent content;
    private final JFigletPreferences preferences;

    public JFigletEditor(final FigDriver figDriver, FontModel displayFontModel, JFigletPreferences preferences) {
        Ensure.ensureArgumentNotNull(figDriver);
        Ensure.ensureArgumentNotNull(preferences);
        this.figDriver = figDriver;
        this.preferences = preferences;
        this.processor = new AsynchronousDroppingJobProcessor(new IJobProcessor(){

            public final void process(JobProcessingContext processingContext) {
                IFigletJob job = (IFigletJob)processingContext.getJobObject();
                try {
                    String result = figDriver.figletize(job);
                    JFigletEditor.this.taOutput.setText(result);
                    return;
                }
                catch (FigException figException) {
                    FigException exception = figException;
                    figException.printStackTrace();
                    return;
                }
            }
        });
        this.fontChooser = new FontChooserView(figDriver.getFileLibrary().getFontCategorization(), figDriver);
        this.fontChooser.addFontSelectionListener(new IFontSelectionListener(){

            public final void fontSelectionChanged() {
                JFigletEditor.this.handleFontSelectionChanged();
            }
        });
        AsciiTextAreaProperties taInputProperties = new AsciiTextAreaProperties(displayFontModel);
        this.taInput = new AsciiTextArea(new Dimension(80, 3), taInputProperties);
        this.taInput.setToolTipText("Text to be converted");
        this.taInput.setText("FIGlet");
        this.taInput.addTextContentListener(new ITextContentListener(){

            public final void textContentChanged() {
                JFigletEditor.this.figletize();
            }
        });
        AsciiTextAreaProperties taOutputProperties = new AsciiTextAreaProperties(displayFontModel);
        taOutputProperties.setEditable(false);
        taOutputProperties.getRulerProperties().setHorizontalRulerVisible(true);
        taOutputProperties.getRulerProperties().setPrintMarginColumnVisible(true);
        this.taOutput = new AsciiTextArea(new Dimension(80, 13), taOutputProperties);
        this.taOutput.setToolTipText("Conversion output");
        this.layoutPanel = new FigLayoutPanel();
        this.layoutPanel.addLayoutListener(new IFigLayoutListener(){

            public final void layoutChanged() {
                JFigletEditor.this.figletize();
            }
        });
        JSplitPane mainSplitPane = new JSplitPane(0, this.taInput.getContent(), this.taOutput.getContent());
        mainSplitPane.setBorder(null);
        mainSplitPane.setContinuousLayout(true);
        JPanel mainContent = new JPanel(new BorderLayout(4, 4));
        mainContent.add((Component)this.fontChooser.getContent(), "North");
        mainContent.add((Component)mainSplitPane, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new BorderLayout(4, 4));
        panel.add((Component)this.layoutPanel.getContent(), "North");
        panel.add((Component)mainContent, "Center");
        panel.add((Component)this.createStatusBar(), "South");
        this.taInput.selectAll();
        this.taInput.requestFocus();
        this.taOutput.addTextContentListener(new ITextContentListener(){

            public final void textContentChanged() {
                JFigletEditor.this.updateSizeBar();
            }
        });
        this.setStatus(figDriver.getFileLibrary().getAllFontNames().length + " fonts available.");
        this.updateSizeBar();
        this.handleFontSelectionChanged();
        this.content = panel;
        this.readPreferences();
    }

    public final JComponent getContent() {
        return this.content;
    }

    private void readPreferences() {
        String fontName;
        FigFontCategory category;
        String categoryName = this.preferences.getFigFontCategoryName();
        if (categoryName != null && (category = FigUtilities.getCategory(this.figDriver.getFileLibrary().getFontCategorization(), categoryName)) != null) {
            this.fontChooser.setSelectedCategory(category);
        }
        if ((fontName = this.preferences.getFigFontName()) != null) {
            try {
                FigFont font = this.figDriver.getFont(fontName);
                if (font != null) {
                    this.fontChooser.setSelectedFont(font);
                }
                return;
            }
            catch (FigException figException) {}
        }
    }

    private void updateSizeBar() {
        Dimension dimension = this.taOutput.getTextSize();
        this.sizeBar.setDimension(dimension);
    }

    private JComponent createStatusBar() {
        this.statusBar = new JTextField();
        this.statusBar.setEditable(false);
        this.sizeBar = new DimensionTextField();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.statusBar, "Center");
        panel.add((Component)this.sizeBar.getContent(), "East");
        return panel;
    }

    private void setStatus(String message) {
        this.statusBar.setText(message);
    }

    private void handleFontSelectionChanged() {
        this.layoutPanel.setLayout(this.getSelectedFont().getLayout());
        this.figletize();
    }

    private FigFont getSelectedFont() {
        return this.fontChooser.getSelectedFont();
    }

    protected final void figletize() {
        String text = this.taInput.getText();
        FigFont selectedFont = this.getSelectedFont();
        FigLayout layout = this.layoutPanel.getLayout();
        HorizontalAlignment alignment = this.layoutPanel.getAlignment();
        this.processor.startJob(FigletJobFactory.createJob(text, selectedFont, layout, alignment));
    }

    public final String getResultText() {
        return this.taOutput.getText();
    }
}

