/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.fontchooser;

import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.swing.ui.FigletIcons;
import de.jave.figlet.swing.ui.Resources;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;

public final class CategoriesTreeCellRenderer
extends DefaultTreeCellRenderer
implements TreeCellRenderer {
    private static final Icon FOLDER_CLOSED_ICON = Resources.getIconResource("folder.gif");
    private static final Icon FOLDER_OPEN_ICON = Resources.getIconResource("folder_open.gif");

    public final Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        if (!(value instanceof DefaultMutableTreeNode)) {
            throw new IllegalStateException();
        }
        Object object = ((DefaultMutableTreeNode)value).getUserObject();
        if (!(object instanceof FigFontCategory)) {
            return this;
        }
        FigFontCategory category = (FigFontCategory)object;
        this.setText(this.getDisplayName(category));
        this.setToolTipText(this.getToolTipText(category));
        Icon icon = null;
        icon = leaf ? (category.getFontCount() == 0 ? FigletIcons.FONT_CATEGORY_ICON_DISABLED : FigletIcons.FONT_CATEGORY_ICON) : (expanded ? FOLDER_OPEN_ICON : FOLDER_CLOSED_ICON);
        this.setIcon(icon);
        return this;
    }

    private String getToolTipText(FigFontCategory category) {
        String description = category.getDescription();
        if (description == null || description.length() == 0) {
            return null;
        }
        return description;
    }

    private String getDisplayName(FigFontCategory category) {
        int size = category.getFontCount();
        if (size > 0) {
            return category.getName() + " (" + size + ")";
        }
        return category.getName();
    }
}

