/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.swing.fontchooser;

import de.jave.figlet.IFontCategorySelectionListener;
import de.jave.figlet.IFontSelectionListener;
import de.jave.figlet.engine.FigDriver;
import de.jave.figlet.engine.primitives.FigFont;
import de.jave.figlet.file.FigFontCategorization;
import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.swing.fontchooser.CategoriesView;
import de.jave.figlet.swing.fontchooser.FontListView;
import de.jave.figlet.util.FigException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;

public final class FontChooserView {
    private JComponent content;
    private FontListView fontListView;
    private List listeners = new ArrayList();
    private FigFont currentFont;
    private CategoriesView categoriesView;

    public FontChooserView(FigFontCategorization categorization, final FigDriver figDriver) {
        try {
            this.currentFont = figDriver.getFont(figDriver.getFileLibrary().getDefaultFontName());
        }
        catch (FigException figException) {
            FigException exception1 = figException;
            figException.printStackTrace();
        }
        this.categoriesView = new CategoriesView(categorization);
        this.fontListView = new FontListView(figDriver);
        this.categoriesView.addFontCategorySelectionListener(new IFontCategorySelectionListener(){

            public final void categorySelectionChanged() {
                FigFontCategory selectedCategory = FontChooserView.this.categoriesView.getSelectedCategory();
                FontChooserView.this.fontListView.setFontCategory(selectedCategory);
                if (FontChooserView.this.currentFont != null && selectedCategory != null && selectedCategory.containsFont(FontChooserView.this.currentFont.getName())) {
                    FontChooserView.this.fontListView.setSelectedFont(FontChooserView.this.currentFont.getName());
                }
            }
        });
        this.fontListView.addFontSelectionListener(new IFontSelectionListener(){

            public final void fontSelectionChanged() {
                FigFont font;
                String selectedFontName = FontChooserView.this.getSelectedFontName();
                if (selectedFontName == null) {
                    return;
                }
                if (selectedFontName.equals(FontChooserView.this.currentFont.getName())) {
                    return;
                }
                try {
                    font = figDriver.getFont(selectedFontName);
                }
                catch (FigException exception) {
                    JOptionPane.showMessageDialog(FontChooserView.this.content, "Unable to load the selected font '" + selectedFontName + "'\n" + "(" + exception.getMessage() + ")", "FIGlet font error", 0);
                    if (FontChooserView.this.currentFont != null) {
                        FontChooserView.this.setSelectedFont(FontChooserView.this.currentFont);
                    }
                    return;
                }
                FontChooserView.this.currentFont = font;
                FontChooserView.this.fireFontSelectionChanged();
            }
        });
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)new JLabel("Font category:"), "North");
        leftPanel.add((Component)this.categoriesView.getContent(), "Center");
        JSplitPane pane = new JSplitPane(1, leftPanel, this.fontListView.getContent());
        pane.setBorder(null);
        pane.setContinuousLayout(true);
        this.content = pane;
        FigFontCategory defaultCategory = categorization.getDefaultCategory();
        this.categoriesView.setSelectedCategory(defaultCategory);
        this.fontListView.setSelectedFont(figDriver.getFileLibrary().getDefaultFontName());
    }

    public final JComponent getContent() {
        return this.content;
    }

    private String getSelectedFontName() {
        return this.fontListView.getSelectedFont();
    }

    public final synchronized void addFontSelectionListener(IFontSelectionListener listener) {
        this.listeners.add(listener);
    }

    protected final synchronized void fireFontSelectionChanged() {
        for (int i = 0; i < this.listeners.size(); ++i) {
            IFontSelectionListener listener = (IFontSelectionListener)this.listeners.get(i);
            listener.fontSelectionChanged();
        }
    }

    public final void setSelectedFont(FigFont font) {
        this.currentFont = font;
        this.fontListView.setSelectedFont(font.getName());
    }

    public final FigFont getSelectedFont() {
        return this.currentFont;
    }

    public final void setSelectedCategory(FigFontCategory category) {
        this.categoriesView.setSelectedCategory(category);
    }
}

