/*
 * Decompiled with CFR 0.152.
 */
package de.jave.figlet.util;

import de.jave.figlet.file.FigFontCategorization;
import de.jave.figlet.file.FigFontCategory;
import de.jave.figlet.file.IFigFontCategoryContainer;
import java.util.ArrayList;
import java.util.Arrays;

public final class FigUtilities {
    private FigUtilities() {
    }

    public static final int stringToInt(String line) throws NumberFormatException {
        int base = 10;
        if (line.startsWith("0x")) {
            base = 16;
            line = line.substring(2);
        }
        return Integer.parseInt(line, base);
    }

    public static final FigFontCategory[] getAllCategories(FigFontCategorization categorization) {
        return FigUtilities.getAllCategoriesInternal(categorization);
    }

    private static FigFontCategory[] getAllCategoriesInternal(IFigFontCategoryContainer categorization) {
        ArrayList<FigFontCategory> all = new ArrayList<FigFontCategory>();
        FigFontCategory[] categories = categorization.getChildCategories();
        for (int i = 0; i < categories.length; ++i) {
            all.add(categories[i]);
            all.addAll(Arrays.asList(FigUtilities.getAllCategoriesInternal(categories[i])));
        }
        return all.toArray(new FigFontCategory[all.size()]);
    }

    public static final FigFontCategory[] getCategoriesContainingFont(FigFontCategorization categorization, String fontName) {
        FigFontCategory[] categories = FigUtilities.getAllCategories(categorization);
        ArrayList<FigFontCategory> result = new ArrayList<FigFontCategory>();
        for (int i = 0; i < categories.length; ++i) {
            boolean contained = categories[i].containsFont(fontName);
            if (!contained) continue;
            result.add(categories[i]);
        }
        return result.toArray(new FigFontCategory[result.size()]);
    }

    public static final FigFontCategory getCategory(FigFontCategorization categorization, String categoryName) {
        FigFontCategory[] categories = FigUtilities.getAllCategories(categorization);
        for (int i = 0; i < categories.length; ++i) {
            FigFontCategory category = categories[i];
            if (!categoryName.equals(category.getName())) continue;
            return category;
        }
        return null;
    }
}

