/*
 * Decompiled with CFR 0.152.
 */
package de.jave.formula2;

import de.jave.formula2.FormulaCharField;
import java.util.Vector;

public final class Formula2Algo {
    private Formula2Algo() {
    }

    static final FormulaCharField matrix(int rows, int cols, Vector v) {
        while (v.size() < rows * cols) {
            v.addElement(new FormulaCharField("0"));
        }
        int[] rowHeights = new int[rows];
        int[] rowAscents = new int[rows];
        int[] colWidths = new int[cols];
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < cols; ++x) {
                FormulaCharField f = (FormulaCharField)v.elementAt(y * cols + x);
                int fAscent = f.ascent;
                int fHeight = f.height;
                if (y > 0 && f.isTopWeak()) {
                    --fAscent;
                    --fHeight;
                }
                if (f.width > colWidths[x]) {
                    colWidths[x] = f.width;
                }
                if (fAscent > rowAscents[y]) {
                    rowAscents[y] = fAscent;
                }
                if (rowAscents[y] - fAscent + fHeight <= rowHeights[y]) continue;
                rowHeights[y] = rowAscents[y] - fAscent + fHeight;
            }
        }
        int height = 0;
        for (int y = 0; y < rows; ++y) {
            height += rowHeights[y];
        }
        height += rows - 1;
        int width = 0;
        for (int x = 0; x < cols; ++x) {
            width += colWidths[x];
        }
        FormulaCharField g = new FormulaCharField(width += cols - 1, height, height / 2);
        int yy = 0;
        for (int y = 0; y < rows; ++y) {
            int xx = 0;
            for (int x = 0; x < cols; ++x) {
                FormulaCharField f = (FormulaCharField)v.elementAt(y * cols + x);
                f.pasteInto(g, xx + (colWidths[x] - f.width) / 2, yy + rowAscents[y] - f.ascent);
                xx += colWidths[x] + 1;
            }
            yy += rowHeights[y] + 1;
        }
        return g;
    }

    static final FormulaCharField binomial(FormulaCharField f1, FormulaCharField f2) {
        int height = f1.height + f2.height + 1;
        int width = Formula2Algo.max(f1.width, f2.width);
        FormulaCharField g = new FormulaCharField(width, height, height / 2);
        f1.pasteInto(g, (width - f1.width) / 2, 0);
        f2.pasteInto(g, (width - f2.width) / 2, f1.height + 1);
        return Formula2Algo.roundBrackets(g);
    }

    static final FormulaCharField roundBrackets(FormulaCharField f) {
        int h = f.height;
        if (h == 2) {
            ++h;
        }
        if (h == 1) {
            FormulaCharField g = new FormulaCharField(f.width + 2, 1);
            g.set(0, 0, '(');
            g.set(g.width - 1, 0, ')');
            f.pasteInto(g, 1, 0);
            return g;
        }
        FormulaCharField g = new FormulaCharField(f.width + 6, h, f.ascent);
        if (h == 3 && f.height == 2 && f.ascent == 0) {
            f.pasteInto(g, 3, 1);
            ++g.ascent;
        } else {
            f.pasteInto(g, 3, 0);
        }
        g.set(1, 0, '/');
        g.set(g.width - 2, 0, '\\');
        g.set(1, g.height - 1, '\\');
        g.set(g.width - 2, g.height - 1, '/');
        for (int y = 1; y < g.height - 1; ++y) {
            g.set(0, y, '|');
            g.set(g.width - 1, y, '|');
        }
        return g;
    }

    static final FormulaCharField spitzBrackets(FormulaCharField f) {
        int height = f.height;
        if (height == 2) {
            ++height;
        }
        int klammerBreite = (height + 1) / 2;
        int schraegStrichAnzahl = height / 2;
        FormulaCharField g = new FormulaCharField(f.width + 2 * klammerBreite, height, f.ascent);
        f.pasteInto(g, klammerBreite, 0);
        if (height / 2 * 2 != height) {
            g.set(0, height / 2, '<');
            g.set(g.width - 1, height / 2, '>');
        }
        for (int i = 0; i < schraegStrichAnzahl; ++i) {
            g.set(klammerBreite - i - 1, i, '/');
            g.set(g.width - klammerBreite + i, i, '\\');
            g.set(klammerBreite - i - 1, height - i - 1, '\\');
            g.set(g.width - klammerBreite + i, height - i - 1, '/');
        }
        return g;
    }

    static final FormulaCharField eckigBrackets(FormulaCharField f) {
        int h = f.height;
        if (h == 1) {
            FormulaCharField g = new FormulaCharField(f.width + 2, 1);
            g.set(0, 0, '[');
            g.set(g.width - 1, 0, ']');
            f.pasteInto(g, 1, 0);
            return g;
        }
        int delta = 1;
        if (f.isTopWeak()) {
            delta = 0;
        }
        FormulaCharField g = new FormulaCharField(f.width + 6, h + delta, f.ascent + delta);
        f.pasteInto(g, 3, delta);
        g.set(1, 0, '_');
        g.set(g.width - 2, 0, '_');
        g.set(1, g.height - 1, '_');
        g.set(g.width - 2, g.height - 1, '_');
        for (int y = 1; y < g.height; ++y) {
            g.set(0, y, '|');
            g.set(g.width - 1, y, '|');
        }
        return g;
    }

    static final FormulaCharField floor(FormulaCharField f) {
        FormulaCharField g = new FormulaCharField(f.width + 6, f.height, f.ascent);
        f.pasteInto(g, 3, 0);
        g.set(1, g.height - 1, '_');
        g.set(g.width - 2, g.height - 1, '_');
        for (int y = 0; y < g.height; ++y) {
            g.set(0, y, '|');
            g.set(g.width - 1, y, '|');
        }
        return g;
    }

    static final FormulaCharField ceil(FormulaCharField f) {
        int delta = 1;
        if (f.height > 2 && f.isTopWeak()) {
            delta = 0;
        }
        FormulaCharField g = new FormulaCharField(f.width + 6, f.height + delta, f.ascent + delta);
        f.pasteInto(g, 3, delta);
        g.set(1, 0, '_');
        g.set(g.width - 2, 0, '_');
        for (int y = 1; y < g.height; ++y) {
            g.set(0, y, '|');
            g.set(g.width - 1, y, '|');
        }
        return g;
    }

    static final FormulaCharField straightBrackets(FormulaCharField f) {
        FormulaCharField g = new FormulaCharField(f.width + 4, f.height, f.ascent);
        f.pasteInto(g, 2, 0);
        for (int y = 0; y < g.height; ++y) {
            g.set(0, y, '|');
            g.set(g.width - 1, y, '|');
        }
        return g;
    }

    static final FormulaCharField straightDoubleBrackets(FormulaCharField f) {
        FormulaCharField g = new FormulaCharField(f.width + 6, f.height, f.ascent);
        f.pasteInto(g, 3, 0);
        for (int y = 0; y < g.height; ++y) {
            g.set(0, y, '|');
            g.set(1, y, '|');
            g.set(g.width - 1, y, '|');
            g.set(g.width - 2, y, '|');
        }
        return g;
    }

    static final FormulaCharField sqrt(FormulaCharField f) {
        return Formula2Algo.sqrt(f, null);
    }

    static final FormulaCharField sqrt(FormulaCharField f, FormulaCharField base) {
        int i;
        int d = Formula2Algo.min(4, f.height + 1);
        int top = 0;
        int left = 0;
        int height = f.height + 1;
        int width = f.width + d + 2;
        int ascent = (height + 1) / 2;
        if (base != null) {
            if (ascent < base.height) {
                height += base.height - ascent;
                top = base.height - ascent;
                ascent = base.height;
            }
            if (base.width > 2) {
                left = base.width - 2;
                if (f.height > 2) {
                    --left;
                }
                width += left;
            }
        }
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        f.pasteInto(g, d + 1 + left, 1 + top);
        for (i = 0; i < f.width + 2; ++i) {
            g.set(d + i + left, top, '_');
        }
        for (i = 0; i < f.height; ++i) {
            g.set(d - 1 + left, i + 1 + top, '|');
        }
        if (f.height > 1) {
            g.set(left, ascent - 1, '_');
        }
        if (base != null) {
            int xx = left + 2 - base.width;
            if (f.height == 1) {
                --xx;
            }
            int yy = ascent - base.height;
            if (base.width > 1 && f.height != 2) {
                ++xx;
            }
            base.pasteInto(g, xx, yy);
        }
        int xd0 = 1;
        int yd0 = ascent;
        if (f.height == 1) {
            xd0 = 0;
        }
        while (xd0 < d - 1) {
            g.set(xd0 + left, yd0, '\\');
            ++xd0;
            ++yd0;
        }
        return g;
    }

    protected static final void drawIntegralSymbol(FormulaCharField g, int x0, int y0, int height) {
        g.set(x0 + 2, y0, '/');
        g.set(x0, y0 + height - 1, '/');
        for (int y = 1; y < height - 1; ++y) {
            g.set(x0 + 1, y0 + y, '|');
        }
    }

    static final FormulaCharField integral(FormulaCharField f) {
        int ascent = Formula2Algo.max(1, f.ascent);
        int height = Formula2Algo.max(3, f.height - f.ascent + ascent);
        int width = 4 + f.width;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        f.pasteInto(g, 4, ascent - f.ascent);
        Formula2Algo.drawIntegralSymbol(g, 0, 0, height);
        return g;
    }

    static final FormulaCharField integral(FormulaCharField f1, FormulaCharField f2) {
        int ascent = Formula2Algo.max(1, f1.ascent, f2.ascent);
        int height = Formula2Algo.max(3, f1.height - f1.ascent + ascent, f2.height - f2.ascent + ascent);
        int width = 4 + f1.width + 1 + 1 + f2.width;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        f1.pasteInto(g, 4, ascent - f1.ascent);
        f2.pasteInto(g, 4 + f1.width + 2, ascent - f2.ascent);
        g.set(4 + f1.width + 1, ascent, 'd');
        Formula2Algo.drawIntegralSymbol(g, 0, 0, height);
        return g;
    }

    static final FormulaCharField integral(FormulaCharField f1, FormulaCharField f2, FormulaCharField f3) {
        int d = Formula2Algo.max(3, f3.width);
        int ascent = Formula2Algo.max(1, f1.ascent, f2.ascent);
        int height = f3.height + Formula2Algo.max(3, f1.height - f1.ascent + ascent, f2.height - f2.ascent + ascent);
        int width = d + 1 + f1.width + 1 + 1 + f2.width;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        f1.pasteInto(g, d + 1, ascent - f1.ascent);
        f2.pasteInto(g, d + 1 + f1.width + 2, ascent - f2.ascent);
        g.set(d + 1 + f1.width + 1, ascent, 'd');
        Formula2Algo.drawIntegralSymbol(g, (d - 3) / 2, 0, height - f3.height);
        f3.pasteInto(g, (d - f3.width) / 2, height - f3.height);
        return g;
    }

    static final FormulaCharField integral(FormulaCharField f1, FormulaCharField f2, FormulaCharField f3, FormulaCharField f4) {
        return new FormulaCharField("INTEGRAL(x;y;u;v)");
    }

    static final FormulaCharField sum(FormulaCharField fs, FormulaCharField fstart, FormulaCharField fend) {
        int ascent = Formula2Algo.max(fend.height + 2, fs.ascent);
        int height = 1 + ascent + Formula2Algo.max(2 + fstart.height, fs.height - fs.ascent);
        int width = fs.width + Formula2Algo.max(fstart.width, fend.width, 3) + 1;
        int d = width - fs.width;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        fend.pasteInto(g, (d - fend.width) / 2, ascent - 3 - fend.height + 1);
        fstart.pasteInto(g, (d - fstart.width) / 2, ascent + 3);
        int e = (d - 3) / 2;
        Formula2Algo.drawSumSymbol(g, e, ascent);
        fs.pasteInto(g, d, ascent - fs.ascent);
        return g;
    }

    static final FormulaCharField sum(FormulaCharField f, FormulaCharField fover) {
        int ascent = Formula2Algo.max(2, f.ascent);
        int height = 1 + ascent + Formula2Algo.max(2 + fover.height, f.height - f.ascent);
        int width = f.width + Formula2Algo.max(fover.width, 3) + 1;
        int d = width - f.width;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        fover.pasteInto(g, (d - fover.width) / 2, ascent + 3);
        int e = (d - 3) / 2;
        Formula2Algo.drawSumSymbol(g, e, ascent);
        f.pasteInto(g, d, ascent - f.ascent);
        return g;
    }

    static final FormulaCharField sum(FormulaCharField f) {
        int ascent = Formula2Algo.max(2, f.ascent);
        int height = 1 + ascent + Formula2Algo.max(2, f.height - f.ascent);
        int width = f.width + 4;
        boolean d = false;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        Formula2Algo.drawSumSymbol(g, 0, ascent);
        f.pasteInto(g, 4, ascent - f.ascent);
        return g;
    }

    protected static final void drawSumSymbol(FormulaCharField g, int x, int y) {
        g.set(x + 1, y, '>');
        g.set(x, y - 1, '\\');
        g.set(x, y + 1, '/');
        g.insert("---", x, y - 2);
        g.insert("---", x, y + 2);
    }

    protected static final void drawProdSymbol(FormulaCharField g, int x, int y) {
        g.insert("_____", x, y - 2);
        g.set(x + 1, y - 1, '|');
        g.set(x + 1, y, '|');
        g.set(x + 1, y + 1, '|');
        g.set(x + 3, y - 1, '|');
        g.set(x + 3, y, '|');
        g.set(x + 3, y + 1, '|');
    }

    static final FormulaCharField prod(FormulaCharField fs, FormulaCharField fstart, FormulaCharField fend) {
        int ascent = Formula2Algo.max(fend.height + 2, fs.ascent);
        int height = 1 + ascent + Formula2Algo.max(1 + fstart.height, fs.height - fs.ascent);
        int width = fs.width + Formula2Algo.max(fstart.width, fend.width, 5) + 1;
        int d = width - fs.width;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        fend.pasteInto(g, (d - fend.width) / 2, ascent - 3 - fend.height + 1);
        fstart.pasteInto(g, (d - fstart.width) / 2, ascent + 2);
        int e = (d - 5) / 2;
        Formula2Algo.drawProdSymbol(g, e, ascent);
        fs.pasteInto(g, d, ascent - fs.ascent);
        return g;
    }

    static final FormulaCharField prod(FormulaCharField f, FormulaCharField fover) {
        int ascent = Formula2Algo.max(2, f.ascent);
        int height = 1 + ascent + Formula2Algo.max(1 + fover.height, f.height - f.ascent - 1);
        int width = f.width + Formula2Algo.max(fover.width, 5) + 1;
        int d = width - f.width;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        fover.pasteInto(g, (d - fover.width) / 2, ascent + 2);
        int e = (d - 5) / 2;
        Formula2Algo.drawProdSymbol(g, e, ascent);
        f.pasteInto(g, d, ascent - f.ascent);
        return g;
    }

    static final FormulaCharField prod(FormulaCharField f) {
        int ascent = Formula2Algo.max(2, f.ascent);
        int height = 1 + ascent + Formula2Algo.max(1, f.height - f.ascent);
        int width = f.width + 6;
        boolean d = false;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        Formula2Algo.drawProdSymbol(g, 0, ascent);
        f.pasteInto(g, 6, ascent - f.ascent);
        return g;
    }

    static final FormulaCharField seq(FormulaCharField f1, FormulaCharField f2, String symbol, int distance) {
        int ascent = Formula2Algo.max(f1.ascent, f2.ascent);
        int height = ascent + Formula2Algo.max(f1.height - f1.ascent, f2.height - f2.ascent);
        int width = f1.width + 2 * distance + symbol.length() + f2.width;
        FormulaCharField ft = new FormulaCharField(width, height);
        new FormulaCharField(width, height).ascent = ascent;
        f1.pasteInto(ft, 0, ascent - f1.ascent);
        f2.pasteInto(ft, f1.width + 2 * distance + symbol.length(), ascent - f2.ascent);
        ft.insert(symbol, f1.width + distance, ascent);
        return ft;
    }

    static final FormulaCharField seq(FormulaCharField f1, FormulaCharField f2, char symbol, int distance) {
        if (symbol == '|') {
            FormulaCharField g = Formula2Algo.seq(f1, f2, " | ", distance);
            for (int y = 0; y < g.height; ++y) {
                g.set(f1.width + 1, y, '|');
            }
            return g;
        }
        return Formula2Algo.seq(f1, f2, String.valueOf(symbol), distance);
    }

    static final FormulaCharField faculty(FormulaCharField f) {
        return Formula2Algo.append(f, '!');
    }

    static final FormulaCharField append(FormulaCharField f, char ch) {
        FormulaCharField ft = new FormulaCharField(f.width + 1, f.height);
        f.pasteInto(ft, 0, 0);
        ft.ascent = f.ascent;
        ft.set(ft.width - 1, ft.ascent, ch);
        return ft;
    }

    static final FormulaCharField fraction(FormulaCharField f1, FormulaCharField f2) {
        boolean ascent = false;
        int height = f1.height + f2.height + 1;
        int width = Formula2Algo.max(f1.width, f2.width);
        if (f1.height > 2 || f2.height > 2) {
            width += 2;
        }
        FormulaCharField ft = new FormulaCharField(width, height);
        new FormulaCharField(width, height).ascent = f1.height;
        f1.pasteInto(ft, (width - f1.width) / 2, 0);
        f2.pasteInto(ft, (width - f2.width) / 2, f1.height + 1);
        for (int i = 0; i < width; ++i) {
            ft.set(i, f1.height, '-');
        }
        return ft;
    }

    static final FormulaCharField sub(FormulaCharField f1, FormulaCharField f2) {
        int delta = 0;
        while (delta + 1 < f1.width && f1.get(f1.width - delta - 1, f1.height - 1) == ' ') {
            ++delta;
        }
        int height = f1.height + f2.height;
        int width = f1.width + f2.width - delta;
        if (width < f1.width) {
            width = f1.width;
        }
        int ascent = f1.ascent;
        FormulaCharField g = new FormulaCharField(width, height, ascent);
        f1.pasteInto(g, 0, 0);
        f2.pasteInto(g, f1.width - delta, f1.height);
        return g;
    }

    static final FormulaCharField sup(FormulaCharField f1, FormulaCharField f2) {
        int delta = 0;
        if (f1.isTopWeak()) {
            delta = 1;
        }
        int height = f1.height + f2.height - delta;
        int width = f1.width + f2.width;
        int ascent = f2.height + f1.ascent - delta;
        FormulaCharField ft = new FormulaCharField(width, height, ascent);
        f1.pasteInto(ft, 0, f2.height - delta);
        f2.pasteInto(ft, f1.width, 0);
        return ft;
    }

    static final FormulaCharField negative(FormulaCharField f) {
        int delta = 0;
        if (f.height > 2) {
            delta = 1;
        }
        FormulaCharField g = new FormulaCharField(f.width + 1 + delta, f.height, f.ascent);
        f.pasteInto(g, 1 + delta, 0);
        g.set(0, g.ascent, '-');
        return g;
    }

    static final FormulaCharField not(FormulaCharField f) {
        int height = f.height;
        int ascent = f.ascent;
        if (height == 1) {
            ++height;
            ++ascent;
        } else if (ascent == 0) {
            ++height;
            ++ascent;
        }
        FormulaCharField g = new FormulaCharField(f.width + 3, height, ascent);
        f.pasteInto(g, 3, ascent - f.ascent);
        g.set(0, g.ascent - 1, '_');
        g.set(1, g.ascent, '|');
        return g;
    }

    static final FormulaCharField function(String name, FormulaCharField f) {
        int offSet = name.length();
        FormulaCharField g = Formula2Algo.roundBrackets(f);
        FormulaCharField h = new FormulaCharField(g.width + offSet, g.height, g.ascent);
        g.pasteInto(h, offSet, 0);
        h.insert(name, 0, g.ascent);
        return h;
    }

    static final FormulaCharField vector(FormulaCharField f) {
        int width = Formula2Algo.max(f.width, 2);
        FormulaCharField g = new FormulaCharField(width, f.height + 1, f.ascent + 1);
        f.pasteInto(g, 0, 1);
        g.set(width - 1, 0, '>');
        for (int i = 0; i < width - 1; ++i) {
            g.set(i, 0, '-');
        }
        return g;
    }

    static final FormulaCharField overline(FormulaCharField f) {
        FormulaCharField g = new FormulaCharField(f.width, f.height + 1, f.ascent + 1);
        f.pasteInto(g, 0, 1);
        for (int i = 0; i < f.width; ++i) {
            g.set(i, 0, '_');
        }
        return g;
    }

    static final FormulaCharField underline(FormulaCharField f) {
        FormulaCharField g = new FormulaCharField(f.width, f.height + 1, f.ascent);
        f.pasteInto(g, 0, 0);
        for (int i = 0; i < f.width; ++i) {
            g.set(i, f.height, '-');
        }
        return g;
    }

    static final FormulaCharField lim(FormulaCharField f1, FormulaCharField f2) {
        int ascent = f2.ascent;
        int height = ascent + 1 + Formula2Algo.max(f2.height - f2.ascent - 1, f1.height);
        int width = 1 + Formula2Algo.max(3, f1.width) + f2.width;
        FormulaCharField ft = new FormulaCharField(width, height);
        new FormulaCharField(width, height).ascent = ascent;
        f1.pasteInto(ft, 0, height - f1.height);
        f2.pasteInto(ft, width - f2.width, 0);
        ft.insert("lim", (width - f2.width - 4) / 2, ascent);
        return ft;
    }

    static final FormulaCharField log(FormulaCharField f1, FormulaCharField f2) {
        int ascent = f2.ascent;
        int height = ascent + 1 + Formula2Algo.max(f1.height, f2.height - f2.ascent - 1);
        int width = 3 + f1.width + f2.width;
        FormulaCharField ft = new FormulaCharField(width, height);
        new FormulaCharField(width, height).ascent = ascent;
        f1.pasteInto(ft, 3, ascent + 1);
        f2.pasteInto(ft, 3 + f1.width, 0);
        ft.insert("log", 0, ascent);
        return ft;
    }

    public static final int max(int a, int b) {
        if (a > b) {
            return a;
        }
        return b;
    }

    public static final int max(int a, int b, int c) {
        if (a > b) {
            if (a > c) {
                return a;
            }
            return c;
        }
        if (b > c) {
            return b;
        }
        return c;
    }

    public static final int min(int a, int b) {
        if (a < b) {
            return a;
        }
        return b;
    }
}

