/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gfx;

import java.awt.Graphics;

public final class GfxUtilities {
    private GfxUtilities() {
    }

    public static final void drawDottedRectangle(Graphics g, int x, int y, int width, int height) {
        GfxUtilities.drawBrokenHorizontalLine(g, x, x + width, y, 1, 0);
        GfxUtilities.drawBrokenHorizontalLine(g, x, x + width, y + height, 1, 0);
        GfxUtilities.drawBrokenVerticalLine(g, x, y, y + height, 1, 0);
        GfxUtilities.drawBrokenVerticalLine(g, x + width, y, y + height, 1, 0);
    }

    public static final void drawBrokenHorizontalLine(Graphics g, int x1, int x2, int y1, int strokeLength, int offset) {
        int count = 0;
        int x = 0;
        for (x = x1; x <= x2; ++x) {
            int pos = (x + strokeLength * 2 - offset) % (strokeLength * 2);
            if (pos < strokeLength) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            g.drawLine(x - count, y1, x - 1, y1);
            count = 0;
        }
        if (count > 0) {
            g.drawLine(x - count, y1, x - 1, y1);
        }
    }

    public static final void drawBrokenVerticalLine(Graphics g, int x1, int y1, int y2, int strokeLength, int offset) {
        int count = 0;
        int y = 0;
        for (y = y1; y <= y2; ++y) {
            int pos = (y + strokeLength * 2 - offset) % (strokeLength * 2);
            if (pos < strokeLength) {
                ++count;
                continue;
            }
            if (count <= 0) continue;
            g.drawLine(x1, y - count, x1, y - 1);
            count = 0;
        }
        if (count > 0) {
            g.drawLine(x1, y - count, x1, y - 1);
        }
    }
}

