/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.internet.InternetTools;
import de.jave.lib.gui.GuiUtilities;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JComponent;

public final class GHyperlink
extends JComponent
implements MouseListener {
    private URL url;
    private String label;
    private boolean pressed;
    public static final Color COLOR_LINK = Color.blue;
    public static final Color COLOR_LINK_PRESSED = new Color(0, 0, 160);
    private int alignment = 0;

    public GHyperlink() {
        this((URL)null, "", 0);
    }

    public GHyperlink(String url, int alignment) {
        this.alignment = alignment;
        this.setURL(url);
        this.addMouseListener(this);
        this.pressed = false;
    }

    public final void setURL(String url) {
        if (url == null || url.length() == 0) {
            this.url = null;
            this.label = "";
        } else {
            try {
                this.url = new URL(url);
                this.label = this.url.toExternalForm();
            }
            catch (MalformedURLException e) {
                this.label = e.toString();
            }
        }
        this.invalidate();
        Container parent = this.getParent();
        if (parent != null) {
            ((Component)parent).validate();
        }
        this.repaint();
    }

    public final void setURL(String url, String label) {
        this.label = label;
        if (url == null || url.length() == 0) {
            this.url = null;
        } else {
            try {
                this.url = new URL(url);
            }
            catch (MalformedURLException e) {
                this.label = e.toString();
            }
        }
        this.invalidate();
        Container parent = this.getParent();
        if (parent != null) {
            ((Component)parent).validate();
        }
        this.repaint();
    }

    public GHyperlink(String url, String label, int alignment) {
        this.alignment = alignment;
        this.label = label;
        this.setURL(url, label);
        this.addMouseListener(this);
        this.pressed = false;
    }

    public GHyperlink(URL url, String label, int alignment) {
        this.alignment = alignment;
        this.label = label;
        this.url = url;
        this.addMouseListener(this);
        this.pressed = false;
    }

    public final Dimension getPreferredSize() {
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int sw = fm.stringWidth(this.label);
        return new Dimension(sw + 3, 15);
    }

    public final Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public final Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    protected final void paintComponent(Graphics g) {
        Dimension d;
        if (this.label == null || this.label.length() == 0) {
            return;
        }
        if (this.pressed) {
            g.setColor(COLOR_LINK_PRESSED);
        } else {
            g.setColor(COLOR_LINK);
        }
        FontMetrics fm = this.getFontMetrics(this.getFont());
        int sw = fm.stringWidth(this.label);
        int x = 0;
        if (this.alignment == 0) {
            x = 1;
        } else if (this.alignment == 2) {
            d = this.getSize();
            x = d.width - sw;
        } else if (this.alignment == 1) {
            d = this.getSize();
            x = (d.width - sw) / 2;
        }
        int y = 0;
        Dimension d2 = this.getSize();
        y = 11 + (d2.height - 15 + 1) / 2;
        g.drawString(this.label, x, y);
        g.drawLine(x, y + 1, x + sw - 1, y + 1);
    }

    public final void mousePressed(MouseEvent evt) {
        if (this.url != null) {
            this.pressed = true;
            this.repaint();
        }
    }

    public final void mouseReleased(MouseEvent evt) {
        if (this.pressed) {
            this.pressed = false;
            this.repaint();
            Applet applet = GuiUtilities.getParentApplet(this);
            if (applet != null) {
                applet.getAppletContext().showDocument(this.url, "_blank");
                return;
            }
            try {
                InternetTools.launchBrowser(this.url);
                return;
            }
            catch (SecurityException e) {
                System.err.println(e);
                return;
            }
        }
    }

    public final void mouseClicked(MouseEvent evt) {
    }

    public final void mouseEntered(MouseEvent evt) {
        this.setCursor(Cursor.getPredefinedCursor(12));
    }

    public final void mouseExited(MouseEvent evt) {
        this.setCursor(Cursor.getDefaultCursor());
        if (this.pressed) {
            this.pressed = false;
            this.repaint();
        }
    }
}

