/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.gui.GButton;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public abstract class GPaintedButton
extends GButton {
    private Image imageDisabled;
    private Image imageEnabled;
    private Image imagePressed;

    public boolean isFocusTraversable() {
        return false;
    }

    protected final void paintComponent(Graphics g) {
        if (this.imageDisabled == null) {
            this.createImages();
        }
        if (!this.isEnabled) {
            g.drawImage(this.imageDisabled, 0, 0, this);
            return;
        }
        if (this.pressed || this.lockable && this.locked) {
            g.drawImage(this.imagePressed, 0, 0, this);
        } else {
            g.drawImage(this.imageEnabled, 0, 0, this);
        }
        this.paintBorder(g);
        this.drawFocus(g, this.getSize());
    }

    private final void createImages() {
        Dimension d = this.getPreferredSize();
        int w = d.width;
        int h = d.height;
        this.imageDisabled = this.createImage(w, h);
        Graphics gDisabled = this.imageDisabled.getGraphics();
        gDisabled.setColor(this.getBackground());
        gDisabled.fillRect(0, 0, w, h);
        this.paintDisabled(gDisabled);
        this.imagePressed = this.createImage(w, h);
        Graphics gPressed = this.imagePressed.getGraphics();
        gPressed.setColor(this.getBackground());
        gPressed.fillRect(0, 0, w, h);
        this.paintPressed(gPressed);
        this.imageEnabled = this.createImage(w, h);
        Graphics gEnabled = this.imageEnabled.getGraphics();
        gEnabled.setColor(this.getBackground());
        gEnabled.fillRect(0, 0, w, h);
        this.paintEnabled(gEnabled);
    }

    protected abstract void paintEnabled(Graphics var1);

    protected abstract void paintDisabled(Graphics var1);

    protected abstract void paintPressed(Graphics var1);
}

