/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui;

import de.jave.awt.clipboard.DefaultClipboardOwner;
import de.jave.awt.clipboard.JaveClipboardSelection;
import de.jave.gui.Resources;
import de.jave.lib.CharacterPlate;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.disy.commons.core.model.AbstractChangeableModel;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;

public final class GTextArea
extends AbstractChangeableModel {
    private final JTextArea textArea;
    private final JComponent content;

    public GTextArea() {
        this("");
    }

    public GTextArea(String text) {
        this(text, 0, 0);
    }

    public GTextArea(int rows, int columns) {
        this("", rows, columns);
    }

    public GTextArea(String text, int rows, int columns) {
        this.textArea = new JTextArea(text, rows, columns);
        this.textArea.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                GTextArea.this.fireChangeEvent();
            }
        });
        this.content = new JScrollPane(this.textArea);
        this.textArea.addKeyListener(new KeyAdapter(){

            public final void keyPressed(KeyEvent e) {
                if (e.isControlDown()) {
                    if (e.getKeyChar() == '9') {
                        GTextArea.this.fontSizeUp();
                        return;
                    }
                    if (e.getKeyChar() == '8') {
                        GTextArea.this.fontSizeDown();
                    }
                }
            }

            public final void keyTyped(KeyEvent e) {
                if (e.isControlDown()) {
                    if (e.getKeyChar() == '\u0001') {
                        GTextArea.this.selectAll();
                        e.consume();
                    }
                    return;
                }
            }
        });
        this.textArea.addMouseListener(new MouseAdapter(){

            public final void mouseReleased(MouseEvent e) {
                if (!e.isMetaDown()) {
                    return;
                }
                GTextArea.this.textArea.requestFocus();
                SmartAction selectAllAction = new SmartAction(this, "Select All"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected final void execute(Component parentComponent) {
                        GTextArea.access$300(3.access$400(this.this$1)).selectAll();
                    }
                };
                SmartAction cutAction = new SmartAction(this, "Cut"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected final void execute(Component parentComponent) {
                        GTextArea.access$500(3.access$400(this.this$1));
                    }
                };
                SmartAction copyAction = new SmartAction(this, "Copy"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected final void execute(Component parentComponent) {
                        GTextArea.access$600(3.access$400(this.this$1));
                    }
                };
                SmartAction pasteAction = new SmartAction(this, "Paste"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected final void execute(Component parentComponent) {
                        GTextArea.access$700(3.access$400(this.this$1));
                    }
                };
                SmartAction zoomInAction = new SmartAction(this, "Zoom in"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected final void execute(Component parentComponent) {
                        3.access$400(this.this$1).increaseFontSize();
                    }
                };
                SmartAction zoomOutAction = new SmartAction(this, "Zoom out"){
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    protected final void execute(Component parentComponent) {
                        3.access$400(this.this$1).decreaseFontSize();
                    }
                };
                if (!GTextArea.this.textArea.isEditable()) {
                    pasteAction.setEnabled(false);
                    cutAction.setEnabled(false);
                }
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                GTextArea.this.updatePasteActionEnabled(clipboard, pasteAction);
                JPopupMenu popup = new JPopupMenu();
                popup.add(zoomInAction);
                popup.add(zoomOutAction);
                popup.addSeparator();
                popup.add(cutAction);
                popup.add(copyAction);
                popup.add(pasteAction);
                popup.addSeparator();
                popup.add(selectAllAction);
                GTextArea.this.textArea.add(popup);
                popup.show(GTextArea.this.textArea, e.getX(), e.getY());
                GTextArea.this.textArea.remove(popup);
            }

            static final /* synthetic */ GTextArea access$400(3 x0) {
                return x0.GTextArea.this;
            }
        });
        this.setFont(Resources.DEFAULT_FIXED_WIDTH_FONT);
    }

    private void updatePasteActionEnabled(Clipboard clipboard, SmartAction pasteAction) {
        Transferable contents = clipboard.getContents(this);
        if (contents == null) {
            pasteAction.setEnabled(false);
            return;
        }
        pasteAction.setEnabled(contents.isDataFlavorSupported(DataFlavor.stringFlavor));
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final synchronized void setEditable(boolean editable) {
        this.textArea.setEditable(editable);
    }

    private void fontSizeUp() {
        this.increaseFontSize();
    }

    private void fontSizeDown() {
        this.decreaseFontSize();
    }

    public final void trim() {
        String s = this.getText();
        if (s.length() == 0) {
            return;
        }
        StringBuffer s2 = new StringBuffer(s.length());
        StringTokenizer st = new StringTokenizer(s, "\n\r", true);
        while (st.hasMoreTokens()) {
            String t = st.nextToken();
            if (!t.equals("\n") && !t.equals("\r")) {
                int i0;
                for (i0 = t.length() - 1; i0 >= 0 && t.charAt(i0) <= ' '; --i0) {
                }
                t = t.substring(0, i0 + 1);
            }
            s2.append(t);
        }
        s = s2.toString();
        int i0 = 0;
        char ch = s.charAt(0);
        while (i0 < s.length() - 1 && (ch == '\n' || ch == '\r')) {
            ch = s.charAt(++i0);
        }
        int i1 = s.length() - 1;
        ch = s.charAt(i1);
        while (i1 > i0 && (ch == '\n' || ch == '\r')) {
            ch = s.charAt(--i1);
        }
        this.setText(s.substring(i0, i1 + 1));
    }

    public final void setFont(Font font) {
        this.textArea.setFont(font);
    }

    public final void setBackground(Color backgroundColor) {
        this.textArea.setBackground(backgroundColor);
    }

    public final void setForeground(Color foregroundColor) {
        this.textArea.setForeground(foregroundColor);
    }

    public final void setText(String text) {
        this.textArea.setText(text);
    }

    public final String getText() {
        return this.textArea.getText();
    }

    public final void requestFocus() {
        this.textArea.requestFocus();
    }

    public final void decreaseFontSize() {
        Font font = this.textArea.getFont();
        int size = font.getSize();
        if (size <= 4) {
            return;
        }
        this.textArea.setFont(font.deriveFont((float)(size - 1)));
    }

    public final void increaseFontSize() {
        Font font = this.textArea.getFont();
        int size = font.getSize();
        if (size > 30) {
            return;
        }
        this.textArea.setFont(font.deriveFont((float)(font.getSize() + 1)));
    }

    public final void selectAll() {
        this.textArea.selectAll();
    }

    private void performPaste() {
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable contents = clipboard.getContents(this);
        if (contents == null) {
            return;
        }
        try {
            String data = (String)contents.getTransferData(DataFlavor.stringFlavor);
            if (data != null) {
                this.paste(data);
            }
            return;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            UnsupportedFlavorException e = unsupportedFlavorException;
            unsupportedFlavorException.printStackTrace();
            return;
        }
        catch (IOException iOException) {
            IOException e = iOException;
            iOException.printStackTrace();
            return;
        }
    }

    private void performCopy() {
        String selectedText = this.textArea.getSelectedText();
        if (selectedText == null) {
            selectedText = this.textArea.getText();
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new JaveClipboardSelection(new CharacterPlate(selectedText)), DefaultClipboardOwner.getInstance());
    }

    private void performCut() {
        String selectedText = this.textArea.getSelectedText();
        if (selectedText == null) {
            selectedText = this.textArea.getText();
            this.textArea.setText("");
        } else {
            this.paste("");
        }
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        clipboard.setContents(new JaveClipboardSelection(new CharacterPlate(selectedText)), DefaultClipboardOwner.getInstance());
    }

    private void paste(String text) {
        String selectedText = this.textArea.getSelectedText();
        if (selectedText == null) {
            int caretPosition = this.textArea.getCaretPosition();
            this.textArea.insert(text, caretPosition);
            return;
        }
        String oldText = this.textArea.getText();
        int selectionStart = this.textArea.getSelectionStart();
        this.textArea.setText(oldText.substring(0, selectionStart) + text + oldText.substring(this.textArea.getSelectionEnd()));
        this.textArea.setCaretPosition(selectionStart + text.length());
    }

    static final /* synthetic */ void access$500(GTextArea x0) {
        x0.performCut();
    }

    static final /* synthetic */ void access$600(GTextArea x0) {
        x0.performCopy();
    }

    static final /* synthetic */ void access$700(GTextArea x0) {
        x0.performPaste();
    }
}

