/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.dialog;

import de.jave.ascii.plate.JaveGuiImageProvider;
import de.jave.gui.layout.CenterLayout;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.dialog.BasicDialogUi;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.message.MessageTypeUi;
import net.disy.commons.swing.widgets.AutoWrappingLabel;

public final class GDialog {
    public static final Font FONT_HEADLINE = new Font("Dialog", 1, 13);
    private int buttonClicked = -1;
    public static final String[] OK = new String[]{BasicDialogUi.OK_TEXT_SMART};
    public static final String[] OK_CANCEL = new String[]{BasicDialogUi.OK_TEXT_SMART, BasicDialogUi.CANCEL_TEXT_SMART};
    public static final String[] CLOSE = new String[]{BasicDialogUi.CLOSE_TEXT_SMART};
    public static final String[] YES_NO_CANCEL = new String[]{"&Yes", "&No", BasicDialogUi.CANCEL_TEXT_SMART};
    private static final String[] STANDARD_BUTTON = OK;
    private static final Icon[] ICONS = new Icon[]{JaveGuiImageProvider.getInstance().getImageIcon("dialog_question.gif"), MessageTypeUi.getIcon(MessageType.WARNING), MessageTypeUi.getIcon(MessageType.INFORMATION), JaveGuiImageProvider.getInstance().getImageIcon("dialog_bomb.gif")};
    private final JDialog dialog;
    private JButton[] buttons;

    public static final JDialog createJDialog(Component parent, String title, boolean modal) {
        Window parentWindow = GuiUtilities.getWindowForComponent(parent);
        JDialog dialog = parentWindow instanceof Frame ? new JDialog((Frame)parentWindow, title, modal) : (parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow, title, modal) : new JDialog((Frame)null, title, modal));
        dialog.setDefaultCloseOperation(0);
        return dialog;
    }

    public GDialog(Component parent, String title, Component content) {
        this(parent, title, "", content, STANDARD_BUTTON, -1);
    }

    public GDialog(Component parent, String title, Component content, String[] buttonTexts) {
        this(parent, title, "", content, buttonTexts, -1);
    }

    public GDialog(Component parent, String title, String headline, Component content) {
        this(parent, title, headline, content, STANDARD_BUTTON, -1);
    }

    public GDialog(Component parent, String title, String text, String[] buttonTexts, int type) {
        this(parent, title, "", text, buttonTexts, type);
    }

    public GDialog(Component parent, String title, String headline, String text, int type) {
        this(parent, title, headline, text, STANDARD_BUTTON, type);
    }

    public GDialog(Component parent, String title, String headline, String text, String[] buttonTexts, int type) {
        this(parent, title, headline, GDialog.createDefaultContent(text), buttonTexts, type);
    }

    private static Component createDefaultContent(String text) {
        JPanel content = new JPanel(new CenterLayout());
        content.add(new AutoWrappingLabel(text).getContent());
        return content;
    }

    private GDialog(Component parent, String title, String headline, Component content, String[] buttonTexts, int type) {
        this.dialog = GDialog.createJDialog(parent, title, true);
        KeyAdapter escapeKeyListener = new KeyAdapter(){

            public final void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    GDialog.this.dialog.dispose();
                }
            }
        };
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowOpened(WindowEvent e) {
                GDialog.this.buttons[0].requestFocus();
            }

            public final void windowClosing(WindowEvent e) {
                GDialog.this.dialog.dispose();
            }
        });
        this.dialog.getRootPane().addKeyListener(escapeKeyListener);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        if (type != -1) {
            Icon icon = ICONS[type];
            JLabel iconLabel = new JLabel(icon);
            iconLabel.setBorder(new EmptyBorder(7, 10, 7, 13));
            JPanel pImage = new JPanel(new CenterLayout());
            pImage.add(iconLabel);
            this.dialog.getContentPane().add((Component)pImage, "West");
        }
        if (headline != null && !headline.equals("")) {
            JLabel lh = new JLabel(headline);
            lh.setFont(FONT_HEADLINE);
            this.dialog.getContentPane().add((Component)lh, "North");
        }
        this.dialog.getContentPane().add(content, "Center");
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        this.buttons = new JButton[buttonTexts.length];
        for (int i = 0; i < buttonTexts.length; ++i) {
            final int index = i;
            SmartAction action = new SmartAction(buttonTexts[i]){

                protected final void execute(Component parentComponent) {
                    GDialog.this.buttonClicked = index;
                    GDialog.this.dialog.dispose();
                }
            };
            this.buttons[i] = new JButton(action);
            this.buttons[i].addKeyListener(escapeKeyListener);
            buttonPanelBuilder.add(this.buttons[i]);
        }
        this.dialog.setDefaultCloseOperation(0);
        this.dialog.getRootPane().setDefaultButton(this.buttons[0]);
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.pack();
        this.dialog.setResizable(false);
        GuiUtilities.centerToParent(this.dialog);
    }

    public final int getAnswer() {
        return this.buttonClicked;
    }

    public final void show() {
        this.setVisible(true);
    }

    public final void setVisible(boolean visible) {
        this.dialog.setVisible(visible);
    }
}

