/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.io;

import de.jave.gui.io.SmartFileFilter;
import java.io.File;
import net.disy.commons.core.string.StringConcatenationBuilder;
import net.disy.commons.core.util.Ensure;

public final class ExtensionFileFilter
extends SmartFileFilter {
    private final String description;
    private final String[] extensions;

    public ExtensionFileFilter(String description, String extension) {
        this(description, new String[]{extension});
    }

    public ExtensionFileFilter(String description, String[] extensions) {
        Ensure.ensureArgumentNotNull(extensions);
        Ensure.ensureArgumentArrayContentsNotNull(extensions);
        Ensure.ensureArgumentNotNull(description);
        Ensure.ensureArgumentTrue("At least one extension must be given, was 0.", extensions.length > 0);
        this.description = description;
        this.extensions = extensions;
    }

    public final boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        return this.fitsExtensions(file);
    }

    private boolean fitsExtensions(File file) {
        for (int i = 0; i < this.extensions.length; ++i) {
            if (!file.getName().toLowerCase().endsWith("." + this.extensions[i].toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public final String getDescription() {
        StringConcatenationBuilder builder = new StringConcatenationBuilder(",");
        for (int i = 0; i < this.extensions.length; ++i) {
            builder.append("*." + this.extensions[i]);
        }
        return this.description + " (" + builder.getString() + ")";
    }

    public final File makeComplete(File file) {
        if (this.fitsExtensions(file)) {
            return file;
        }
        return new File(file.getAbsolutePath() + "." + this.extensions[0]);
    }
}

