/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.io;

import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.io.FileSelection;
import de.jave.gui.io.ISourceFilePanelConfiguration;
import de.jave.jave.JaveImages;
import de.jave.jave.actions.ButtonToolbarBuilder;
import java.awt.Component;
import java.awt.GridLayout;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.grid.IDialogComponent;

public abstract class SourceFilePanel
implements IDialogComponent {
    private final JButton openButton;
    private final JTextField tfImageName;
    private final FileModel fileModel;
    private final JButton closeButton;
    private final SmartAction openAction;
    private final ISourceFilePanelConfiguration configuration;

    public SourceFilePanel(final FileModel fileModel, ISourceFilePanelConfiguration configuration) {
        Ensure.ensureArgumentNotNull(fileModel);
        Ensure.ensureArgumentNotNull(configuration);
        this.fileModel = fileModel;
        this.configuration = configuration;
        this.tfImageName = new JTextField(15);
        this.tfImageName.setEditable(false);
        this.openAction = new SmartAction(){

            protected final void execute(Component parentComponent) {
                SourceFilePanel.this.performOpenImage(parentComponent);
            }
        };
        JaveImages.configureIcons(this.openAction, "open.gif", "open_.gif");
        this.openAction.setToolTipText(configuration.getOpenButtonToolTipText());
        final SmartAction closeAction = new SmartAction(){

            protected final void execute(Component parentComponent) {
                if (SourceFilePanel.this.performCloseFile(parentComponent)) {
                    fileModel.setFile(null);
                }
            }
        };
        JaveImages.configureIcons(closeAction, "close.gif", "close_.gif");
        closeAction.setToolTipText(configuration.getCloseButtonToolTipText());
        fileModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                SourceFilePanel.this.updateCloseActionEnabled(closeAction);
            }
        });
        this.updateCloseActionEnabled(closeAction);
        this.openButton = ButtonToolbarBuilder.createToolbarButton(this.openAction);
        this.closeButton = ButtonToolbarBuilder.createToolbarButton(closeAction);
        fileModel.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                SourceFilePanel.this.updateTextField();
                File file = fileModel.getFile();
                if (file != null) {
                    SourceFilePanel.this.configuration.getFileChooserConfiguration().getCurrentDirectoryModel().setFile(file.getParentFile());
                }
            }
        });
        this.updateTextField();
    }

    private void updateCloseActionEnabled(SmartAction closeAction) {
        closeAction.setEnabled(this.fileModel.getFile() != null);
    }

    private void updateTextField() {
        if (this.fileModel.getFile() == null) {
            this.tfImageName.setText("");
            return;
        }
        this.tfImageName.setText(this.fileModel.getFile().getAbsolutePath());
    }

    private void performOpenImage(Component parentComponent) {
        FileSelection fileSelection = FileChooserUtilities.performOpenFileChooser(parentComponent, this.configuration.getFileChooserConfiguration());
        if (fileSelection.isEmpty()) {
            return;
        }
        boolean success = this.performOpenFile(parentComponent, fileSelection.getFile());
        if (success) {
            this.fileModel.setFile(fileSelection.getFile());
        }
    }

    protected abstract boolean performOpenFile(Component var1, File var2);

    public final JComponent createPanel() {
        GridDialogPanel panel = new GridDialogPanel();
        panel.add(this);
        return panel.getContent();
    }

    public final int getColumnCount() {
        return 3;
    }

    public final void fillInto(JPanel panel, int columnCount) {
        panel.add(new JLabel(this.configuration.getLabel()));
        GridDialogLayoutData data = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        data.setHorizontalSpan(columnCount - 2);
        panel.add((Component)this.tfImageName, data);
        JPanel buttonPanel = new JPanel(new GridLayout(1, 0));
        buttonPanel.add(this.openButton);
        if (this.configuration.isCloseAvailable()) {
            buttonPanel.add(this.closeButton);
        }
        panel.add(buttonPanel);
    }

    protected boolean performCloseFile(Component parentComponent) {
        return true;
    }

    public final FileModel getFileModel() {
        return this.fileModel;
    }

    public final void setEnabled(boolean enabled) {
        this.openAction.setEnabled(enabled);
    }
}

