/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;

public final class CenterLayout
implements LayoutManager,
Serializable {
    public final void addLayoutComponent(String name, Component comp) {
    }

    public final void removeLayoutComponent(Component comp) {
    }

    public final Dimension preferredLayoutSize(Container container) {
        Component c = container.getComponent(0);
        if (c != null) {
            Dimension size = c.getPreferredSize();
            Insets insets = container.getInsets();
            size.width += insets.left + insets.right;
            size.height += insets.top + insets.bottom;
            return size;
        }
        return new Dimension(0, 0);
    }

    public final Dimension minimumLayoutSize(Container container) {
        return this.preferredLayoutSize(container);
    }

    public final void layoutContainer(Container container) {
        if (container.getComponentCount() > 1) {
            throw new IllegalStateException("CenterLayout does not support more than one component, is:" + container.getComponentCount());
        }
        try {
            Component c = container.getComponent(0);
            c.setSize(c.getPreferredSize());
            Dimension size = c.getSize();
            Dimension containerSize = container.getSize();
            Insets containerInsets = container.getInsets();
            containerSize.width -= containerInsets.left + containerInsets.right;
            containerSize.height -= containerInsets.top + containerInsets.bottom;
            if (containerSize.width < size.width) {
                size.width = containerSize.width;
            }
            if (containerSize.height < size.height) {
                size.height = containerSize.height;
            }
            int componentLeft = containerSize.width / 2 - size.width / 2;
            int componentTop = containerSize.height / 2 - size.height / 2;
            c.setBounds(componentLeft += containerInsets.left, componentTop += containerInsets.top, size.width, size.height);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }
}

