/*
 * Decompiled with CFR 0.152.
 */
package de.jave.gui.splash;

import de.jave.gui.splash.IStartupMonitor;
import de.jave.gui.splash.StartupException;
import de.jave.jave.application.startup.JaveStartupRunnable;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import net.disy.commons.core.message.Message;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class SplashScreen {
    private JLabel statusLabel = new JLabel(" ");
    private JWindow window;
    private JPanel panel;

    public SplashScreen(JComponent splashComponent) {
        this.statusLabel.setOpaque(true);
        this.statusLabel.setBackground(Color.white);
        this.statusLabel.setBorder(new Border(this){

            public final boolean isBorderOpaque() {
                return false;
            }

            public final void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.lightGray);
                g.drawLine(x, y, x + width, y);
            }

            public final Insets getBorderInsets(Component c) {
                return new Insets(1, 2, 1, 2);
            }
        });
        this.window = new JWindow();
        this.panel = new JPanel(new BorderLayout());
        this.panel.add((Component)splashComponent, "Center");
        this.panel.add((Component)this.statusLabel, "South");
        this.window.getContentPane().setLayout(new BorderLayout());
        this.window.getContentPane().add((Component)this.panel, "Center");
        this.setBorder(new EtchedBorder(0));
    }

    public final void setBorder(Border border) {
        this.panel.setBorder(border);
    }

    public final void startup(JaveStartupRunnable runnable) {
        this.window.pack();
        GuiUtilities.centerOnScreen(this.window);
        this.window.setVisible(true);
        long startTime = System.currentTimeMillis();
        Thread.yield();
        try {
            runnable.startUp(new IStartupMonitor(){

                public final void beginTask(String taskName, int totalWork) {
                    SplashScreen.this.statusLabel.setText(taskName);
                    Thread.yield();
                }

                public final void subTask(String name) {
                    SplashScreen.this.statusLabel.setText(name);
                    Thread.yield();
                }

                public final JWindow getSplashWindow() {
                    return SplashScreen.this.window;
                }
            });
            long time = System.currentTimeMillis() - startTime;
            if (time < 1500L) {
                try {
                    Thread.sleep(1500L - time);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.window.dispose();
            return;
        }
        catch (StartupException startupException) {
            StartupException exception = startupException;
            startupException.printStackTrace();
            String message = exception.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = exception.toString();
            }
            this.window.dispose();
            MessageDialogFactory.showMessageDialog(this.window, new Message(message, exception));
            System.exit(1);
            return;
        }
        catch (Throwable throwable) {
            Throwable exception = throwable;
            throwable.printStackTrace();
            String message = exception.getLocalizedMessage();
            if (message == null || message.length() == 0) {
                message = exception.toString();
            }
            this.window.dispose();
            MessageDialogFactory.showMessageDialog(this.window, new Message(message, exception));
            System.exit(1);
            return;
        }
    }
}

