/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image2ascii.AsciiGreyScaleTableItem;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.AsciiGreyscaleTableReader;
import de.jave.jave.configuration.ConfigurationException;
import de.jave.jave.configuration.IJavaInitializationContext;
import de.jave.jave.configuration.IJaveInitializable;
import de.jave.lib.Toolbox;
import de.jave.text.TextTools;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public final class AsciiGreyscaleTableConfiguration
implements IJaveInitializable {
    private static final AsciiGreyscaleTableConfiguration instance = new AsciiGreyscaleTableConfiguration();
    private String[] tableNames = new String[0];
    private final Map tableItemsByName = new HashMap();
    private String defaultTableName;

    private AsciiGreyscaleTableConfiguration() {
    }

    public static final AsciiGreyscaleTableConfiguration getInstance() {
        return instance;
    }

    public final AsciiGreyScaleTableItem getAsciiGreyscaleTableItem(String name) {
        return (AsciiGreyScaleTableItem)this.tableItemsByName.get(name);
    }

    public final void initialize(IJavaInitializationContext context) throws ConfigurationException {
        File configurationFile = context.getConfigurationFile("./config/greyscaletables/");
        if (!configurationFile.isDirectory()) {
            throw new ConfigurationException("There is no folder '" + configurationFile + "' containing cofiguration files.");
        }
        String[] fileNames = configurationFile.list();
        int counter = 0;
        for (int i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].toLowerCase().endsWith(".jgt")) continue;
            ++counter;
        }
        if (counter == 0) {
            throw new ConfigurationException("There are no configuration files in folder '" + configurationFile + "'.");
        }
        this.tableNames = new String[counter];
        this.defaultTableName = null;
        int index = 0;
        for (int i = 0; i < fileNames.length; ++i) {
            if (!fileNames[i].toLowerCase().endsWith(".jgt")) continue;
            this.tableNames[index] = fileNames[i].substring(0, fileNames[i].length() - 4);
            if (fileNames[i].charAt(0) == '_') {
                this.tableNames[index] = this.tableNames[index].substring(1);
                this.tableNames[index] = TextTools.firstLetterUp(this.tableNames[index]);
                this.defaultTableName = this.tableNames[index];
            } else {
                this.tableNames[index] = TextTools.firstLetterUp(this.tableNames[index]);
            }
            File f = new File(configurationFile, fileNames[i]);
            AsciiGreyscaleTable newTable = AsciiGreyscaleTableReader.load(f);
            this.tableItemsByName.put(this.tableNames[index], new AsciiGreyScaleTableItem(this.tableNames[index], newTable));
            ++index;
        }
        Toolbox.quickSort(this.tableNames);
        if (this.defaultTableName == null) {
            this.defaultTableName = this.tableNames[0];
        }
    }

    public final AsciiGreyScaleTableItem getDefaultTableItem() {
        return this.getAsciiGreyscaleTableItem(this.defaultTableName);
    }

    public final AsciiGreyScaleTableItem[] getTableItems() {
        AsciiGreyScaleTableItem[] tables = new AsciiGreyScaleTableItem[this.tableNames.length];
        for (int i = 0; i < tables.length; ++i) {
            tables[i] = this.getAsciiGreyscaleTableItem(this.tableNames[i]);
        }
        return tables;
    }
}

