/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image.GImage;
import de.jave.image.Rotation;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.algorithm.dithering.DitheringAlgorithms;
import de.jave.image2ascii.IImage2AsciiAlgorithm;
import de.jave.image2ascii.Image2Texter;
import de.jave.lib.CharacterPlate;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.core.util.Ensure;

public final class ConversionThread
extends Thread {
    private GGreyscaleImage image;
    private final IImage2AsciiAlgorithm algorithm;
    private final int resultWidth;
    private final double shapeFactor;
    private final boolean normalize;
    private final boolean invert;
    private final int highlight;
    private final int shadow;
    private final double gamma;
    private final double sharpen;
    private final int ditherMethode;
    private final Rotation rotate;
    private final Image2Texter image2texter;
    private final IProgressMonitor progressMonitor;

    public ConversionThread(IProgressMonitor progressMonitor, GGreyscaleImage image, int resultWidth, double shapeFactor, boolean normalize, boolean invert, int highlight, int shadow, double gamma, double sharpen, int ditherMethode, Rotation rotate, IImage2AsciiAlgorithm algorithm, Image2Texter image2texter) {
        Ensure.ensureArgumentNotNull(progressMonitor);
        this.progressMonitor = progressMonitor;
        this.image = image;
        this.resultWidth = resultWidth;
        this.shapeFactor = shapeFactor;
        this.normalize = normalize;
        this.invert = invert;
        this.shadow = shadow;
        this.highlight = highlight;
        this.gamma = gamma;
        this.sharpen = sharpen;
        this.ditherMethode = ditherMethode;
        this.algorithm = algorithm;
        this.rotate = rotate;
        this.image2texter = image2texter;
        this.setPriority(4);
    }

    public final void run() {
        try {
            this.progressMonitor.beginTask("Preparing image...", 5);
            ProgressUtilities.checkInterrupted(this.progressMonitor);
            if (this.image == null || this.resultWidth == 0) {
                return;
            }
            ConversionThread.yield();
            int oldWidth = this.image.getWidth();
            int oldHeight = this.image.getHeight();
            ConversionThread.yield();
            int newHeight = 0;
            int newWidth = 0;
            double dimFactor = this.shapeFactor * 0.52;
            if (this.rotate == Rotation.RIGHT || this.rotate == Rotation.LEFT) {
                newHeight = this.resultWidth;
                newWidth = (int)((double)newHeight / (double)oldHeight * (double)oldWidth * dimFactor);
                if (newHeight < 1) {
                    newHeight = 1;
                }
                if (newWidth < 1) {
                    newWidth = 1;
                }
                newHeight *= this.algorithm.getHorizontalPixelsPerChar();
                newWidth *= this.algorithm.getVerticalPixelsPerChar();
            } else {
                newWidth = this.resultWidth;
                newHeight = (int)((double)this.resultWidth / (double)oldWidth * (double)oldHeight * dimFactor);
                if (newHeight < 1) {
                    newHeight = 1;
                }
                if (newWidth < 1) {
                    newWidth = 1;
                }
                newHeight *= this.algorithm.getVerticalPixelsPerChar();
                newWidth *= this.algorithm.getHorizontalPixelsPerChar();
            }
            ConversionThread.yield();
            ProgressUtilities.checkInterrupted(this.progressMonitor);
            this.image = this.image.getScaledInstance(newWidth, newHeight);
            ConversionThread.yield();
            this.progressMonitor.worked(1);
            ProgressUtilities.checkInterrupted(this.progressMonitor);
            ConversionThread.yield();
            this.image = (GGreyscaleImage)this.image.rotate(this.rotate);
            ProgressUtilities.checkInterrupted(this.progressMonitor);
            this.progressMonitor.worked(1);
            this.image = this.image.convert(this.normalize, this.invert, this.gamma, this.highlight, this.shadow);
            ProgressUtilities.checkInterrupted(this.progressMonitor);
            this.progressMonitor.worked(1);
            if (this.sharpen > 0.0) {
                this.image = this.image.sharpen(this.sharpen);
            }
            this.progressMonitor.worked(1);
            ConversionThread.yield();
            ProgressUtilities.checkInterrupted(this.progressMonitor);
            GImage gi = this.image;
            if (this.ditherMethode != -1) {
                gi = new DitheringAlgorithms().dither(this.image, this.ditherMethode);
            }
            this.progressMonitor.worked(1);
            ConversionThread.yield();
            ProgressUtilities.checkInterrupted(this.progressMonitor);
            CharacterPlate cp = this.algorithm.convert(gi, this.progressMonitor);
            this.image2texter.setResult(cp);
            this.progressMonitor.done();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }
}

