/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii;

import de.jave.image2ascii.IImage2AsciiAlgorithm;
import de.jave.image2ascii.IImage2AsciiAlgorithmItem;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.SharedImage2AsciiOptions;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithm1;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithm4;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmBraille;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmEdgeDetect;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmEdgeTracing;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmFeltpen;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmGradient;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmJavE;
import de.jave.image2ascii.algorithm.Image2AsciiAlgorithmPixelPlate;
import java.util.ArrayList;
import net.disy.commons.swing.component.IDisposableComponentContainer;
import net.disy.commons.swing.fontchooser.model.FontModel;

public final class Image2AsciiAlgorithmFactory {
    private Image2AsciiAlgorithmFactory() {
    }

    public static final Image2AsciiAlgorithm[] createAlgorithms(FontModel displayFontModel) {
        SharedImage2AsciiOptions sharedOptions = new SharedImage2AsciiOptions(displayFontModel);
        ArrayList<Image2AsciiAlgorithm> algorithmList = new ArrayList<Image2AsciiAlgorithm>();
        algorithmList.add(new Image2AsciiAlgorithmJavE(sharedOptions));
        algorithmList.add(new Image2AsciiAlgorithm4(sharedOptions));
        algorithmList.add(new Image2AsciiAlgorithm1(sharedOptions));
        algorithmList.add(new Image2AsciiAlgorithmGradient());
        algorithmList.add(new Image2AsciiAlgorithmEdgeTracing());
        algorithmList.add(new Image2AsciiAlgorithmEdgeDetect());
        algorithmList.add(new Image2AsciiAlgorithmPixelPlate());
        algorithmList.add(new Image2AsciiAlgorithmBraille());
        algorithmList.add(new Image2AsciiAlgorithmFeltpen());
        return algorithmList.toArray(new Image2AsciiAlgorithm[algorithmList.size()]);
    }

    public static final Image2AsciiAlgorithm getAlgorithm(String name, FontModel displayFontModel) {
        int i;
        Image2AsciiAlgorithm[] algorithms = Image2AsciiAlgorithmFactory.createAlgorithms(displayFontModel);
        name = name.toLowerCase();
        for (i = 0; i < algorithms.length; ++i) {
            if (!algorithms[i].getName().toLowerCase().equals(name)) continue;
            return algorithms[i];
        }
        for (i = 0; i < algorithms.length; ++i) {
            if (!algorithms[i].getName().toLowerCase().startsWith(name)) continue;
            return algorithms[i];
        }
        return null;
    }

    public static final IImage2AsciiAlgorithmItem[] createAlgorithmItems(FontModel displayFontModel) {
        Image2AsciiAlgorithm[] algorithms = Image2AsciiAlgorithmFactory.createAlgorithms(displayFontModel);
        IImage2AsciiAlgorithmItem[] items = new IImage2AsciiAlgorithmItem[algorithms.length];
        for (int i = 0; i < items.length; ++i) {
            final Image2AsciiAlgorithm algorithm = algorithms[i];
            items[i] = new IImage2AsciiAlgorithmItem(){

                public final IImage2AsciiAlgorithm getAlgorithm() {
                    return algorithm;
                }

                public final IDisposableComponentContainer createAdjustmentComponent() {
                    return algorithm.createAdjustmentComponent();
                }
            };
        }
        return items;
    }
}

