/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.monochrome.GMonochromeImage;
import de.jave.image.monochrome.algorithm.EdgeReduction;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmEdgeDetectOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmEdgeDetectOptionsPanel;
import de.jave.jave.Filter;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public final class Image2AsciiAlgorithmEdgeDetect
extends Image2AsciiAlgorithm {
    private final AlgorithmEdgeDetectOptionsModel optionsModel = new AlgorithmEdgeDetectOptionsModel();

    public final IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    public final Icon getIcon() {
        return null;
    }

    public final void setSpecialChars(String specialCharacters) {
    }

    public final void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    public final String getName() {
        return "Edge Detection";
    }

    public final IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmEdgeDetectOptionsPanel(this.optionsModel);
    }

    private boolean isHires() {
        return this.optionsModel.isHires();
    }

    public final int getVerticalPixelsPerChar() {
        if (this.isHires()) {
            return 4;
        }
        return 1;
    }

    public final int getHorizontalPixelsPerChar() {
        if (this.isHires()) {
            return 3;
        }
        return 1;
    }

    public final boolean isMonochromeImageRequired() {
        return false;
    }

    public final CharacterPlate convert(IValueRaster pixels, IProgressMonitor progressMonitor) {
        if (!(pixels instanceof GGreyscaleImage)) {
            throw new RuntimeException("ValueRaster must be GGreyscalePixel in converter!");
        }
        progressMonitor.beginTask("Converting...", 9);
        GGreyscaleImage g1 = (GGreyscaleImage)pixels;
        GGreyscaleImage g2 = g1.filterLaplace();
        progressMonitor.worked(1);
        g2.invert();
        progressMonitor.worked(1);
        GMonochromeImage gg = g2.threshold(160, 210);
        progressMonitor.worked(1);
        new EdgeReduction().perform(gg);
        progressMonitor.worked(1);
        GMonochromeImage g3 = (GMonochromeImage)gg.getClone();
        progressMonitor.worked(1);
        g3.edgeDespecle();
        progressMonitor.worked(1);
        int width = g3.getWidth();
        int height = g3.getHeight();
        if (this.isHires()) {
            PixelPlate plate = new PixelPlate(0, 0, width / 3, height / 4);
            plate.setMode(PixelPlateMode.PIXEL);
            int[][] ps = g3.getPixels();
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (ps[x][y] >= 128) continue;
                    plate.set(x, y);
                }
            }
            progressMonitor.worked(1);
            plate.convert();
            progressMonitor.worked(1);
            char[][] ch = plate.getResult().getContent();
            for (int y = 0; y < ch.length; ++y) {
                for (int x = 0; x < ch[0].length; ++x) {
                    if (ch[y][x] != '\u0000') continue;
                    ch[y][x] = 32;
                }
            }
            progressMonitor.worked(1);
            return new CharacterPlate(ch);
        }
        int[][] ps = g3.getPixels();
        char[][] ch = new char[height][width];
        progressMonitor.worked(1);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                ch[y][x] = ps[x][y] < 128 ? 35 : 32;
            }
        }
        Filter.init();
        progressMonitor.worked(1);
        Filter.filter(new CharacterPlate(ch), 0);
        progressMonitor.worked(1);
        return new CharacterPlate(ch);
    }
}

