/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm;

import de.jave.image.IValueRaster;
import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.image2ascii.Image2AsciiAlgorithm;
import de.jave.image2ascii.algorithm.AlgorithmGradientOptionsModel;
import de.jave.image2ascii.algorithm.dialog.Image2AsciiAlgorithmGradientOptionsPanel;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.lib.CharacterPlate;
import javax.swing.Icon;
import net.disy.commons.core.model.IChangeableModel;
import net.disy.commons.core.progress.IProgressMonitor;
import net.disy.commons.core.progress.ProgressUtilities;
import net.disy.commons.swing.component.IDisposableComponentContainer;

public final class Image2AsciiAlgorithmGradient
extends Image2AsciiAlgorithm {
    private final AlgorithmGradientOptionsModel optionsModel = new AlgorithmGradientOptionsModel();

    public final IChangeableModel getOptionsModel() {
        return this.optionsModel;
    }

    public final void setGreyscaleTable(AsciiGreyscaleTable greyscaleTable) {
    }

    public final void setSpecialChars(String specialCharacters) {
        this.optionsModel.setGradient(specialCharacters);
    }

    public final String getName() {
        return "Gradient";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("image2ascii/i2a_gradient.gif");
    }

    public final int getVerticalPixelsPerChar() {
        return 1;
    }

    public final int getHorizontalPixelsPerChar() {
        return 1;
    }

    public final boolean isMonochromeImageRequired() {
        return false;
    }

    public final IDisposableComponentContainer createAdjustmentComponent() {
        return new Image2AsciiAlgorithmGradientOptionsPanel(this.optionsModel);
    }

    public final CharacterPlate convert(IValueRaster pixels, IProgressMonitor progressMonitor) throws InterruptedException {
        String gradient = this.optionsModel.getGradient();
        if (gradient.length() == 0) {
            gradient = " ";
        }
        int resolution = gradient.length();
        int width = pixels.getWidth();
        int height = pixels.getHeight();
        progressMonitor.beginTask("Converting...", height);
        CharacterPlate cp = new CharacterPlate(width, height);
        boolean stegano = this.optionsModel.isSteganogram();
        String steganoText = this.optionsModel.getSteganogramText();
        for (int y = 0; y < height; ++y) {
            Thread.yield();
            ProgressUtilities.checkInterrupted(progressMonitor);
            for (int x = 0; x < width; ++x) {
                int characterIndex;
                double d = (double)pixels.getValueAt(x, y) / 255.0;
                int i = (int)((1.0 - d) * (double)resolution);
                if (i >= resolution) {
                    i = resolution - 1;
                }
                if (stegano && (characterIndex = (y * width + x) / 8) < steganoText.length()) {
                    boolean currentBit;
                    int bitIndex = (y * width + x) % 8;
                    boolean iBit = (i & 1) > 0;
                    if (iBit != (currentBit = (steganoText.charAt(characterIndex) & 1 << bitIndex) > 0)) {
                        i = (x + y) % 2 == 0 ? --i : ++i;
                    }
                    if (i < 0) {
                        i += 2;
                    } else if (i >= resolution) {
                        i -= 2;
                    }
                }
                cp.setForce(x, y, gradient.charAt(i));
            }
            progressMonitor.worked(1);
        }
        return cp;
    }
}

