/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.algorithm.dialog;

import de.jave.gui.layout.Gap;
import de.jave.image2ascii.algorithm.Algorithm1OptionsModel;
import de.jave.image2ascii.algorithm.dialog.banned.BannedCharactersPanel;
import de.jave.image2ascii.algorithm.dialog.greyscaletable.GreyScaleTablePanel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.component.IDisposableComponentContainer;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.grid.GridDialogPanel;
import net.disy.commons.swing.layout.grid.IDialogComponent;

public final class Image2AsciiAlgorithm1OptionsPanel
implements IDisposableComponentContainer {
    private final Algorithm1OptionsModel optionsModel;
    private final ChangeListener optionsModelChangeListener;
    private final GreyScaleTablePanel greyScaleTablePanel;
    private final BannedCharactersPanel bannedCharactersPanel;
    private final JComponent content;

    public Image2AsciiAlgorithm1OptionsPanel(final Algorithm1OptionsModel optionsModel) {
        Ensure.ensureArgumentNotNull(optionsModel);
        this.optionsModel = optionsModel;
        final JCheckBox cbDithering = new JCheckBox("Error correction (dithering)", optionsModel.isDithering());
        cbDithering.addActionListener(new ActionListener(this){

            public final void actionPerformed(ActionEvent e) {
                optionsModel.setDithering(cbDithering.isSelected());
            }
        });
        this.optionsModelChangeListener = new ChangeListener(this){

            public final void stateChanged(ChangeEvent e) {
                cbDithering.setSelected(optionsModel.isDithering());
            }
        };
        optionsModel.addChangeListener(this.optionsModelChangeListener);
        GridDialogPanel gridPanel = new GridDialogPanel();
        this.greyScaleTablePanel = new GreyScaleTablePanel(optionsModel.getGreyScaleTableSelectionModel(), optionsModel.getDisplayFontModel());
        gridPanel.add(this.greyScaleTablePanel);
        this.bannedCharactersPanel = new BannedCharactersPanel(optionsModel.getBannedCharactersModel(), optionsModel.getDisplayFontModel());
        gridPanel.add(this.bannedCharactersPanel);
        gridPanel.add(new IDialogComponent(this){

            public final void fillInto(JPanel panel, int columnCount) {
                panel.add(new Gap());
                GridDialogLayoutData layoutData = new GridDialogLayoutData();
                layoutData.setHorizontalSpan(columnCount - 1);
                panel.add(cbDithering);
            }

            public final int getColumnCount() {
                return 2;
            }
        });
        this.content = gridPanel.getContent();
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final void dispose() {
        this.optionsModel.removeChangeListener(this.optionsModelChangeListener);
        this.greyScaleTablePanel.dispose();
        this.bannedCharactersPanel.dispose();
    }
}

