/*
 * Decompiled with CFR 0.152.
 */
package de.jave.image2ascii.dialog;

import de.jave.gui.io.AbstractSourceFilePanelConfiguration;
import de.jave.gui.io.IFileChooserConfiguration;
import de.jave.gui.io.SourceFilePanel;
import de.jave.image.ImageUtilities;
import de.jave.image.gui.BufferedImageDisplayableImage;
import de.jave.image.gui.ImagePanel;
import de.jave.image2ascii.dialog.ImageOpenPerformer;
import de.jave.image2ascii.model.Image2AsciiSourceImageModel;
import de.jave.jave.watermark.ImageIOUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;

public final class Image2AsciiSourceImagePanel {
    private static final Dimension MAX_SIZE = new Dimension(500, 250);
    private final JComponent content;
    private final ImagePanel imagePanel;
    private final Image2AsciiSourceImageModel model;

    public Image2AsciiSourceImagePanel(final Image2AsciiSourceImageModel model) {
        Ensure.ensureArgumentNotNull(model);
        this.model = model;
        this.imagePanel = new ImagePanel();
        model.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                BufferedImage originalImage = model.getSourceImage().getOriginalImage();
                Dimension originalImageSize = new Dimension(originalImage.getWidth(), originalImage.getHeight());
                Dimension viewSize = ImageUtilities.calculateIsometricLimitedSize(originalImageSize, MAX_SIZE);
                Image2AsciiSourceImagePanel.this.imagePanel.setImage(new BufferedImageDisplayableImage(originalImage, viewSize));
            }
        });
        this.imagePanel.getContent().setPreferredSize(new Dimension(400, 200));
        final IFileChooserConfiguration fileChooserConfiguration = ImageIOUtilities.createImageOpenFileChooserConfiguration(model.getCurrentDirectoryModel());
        AbstractSourceFilePanelConfiguration configuration = new AbstractSourceFilePanelConfiguration(this){

            public final String getOpenButtonToolTipText() {
                return "Open Image File";
            }

            public final IFileChooserConfiguration getFileChooserConfiguration() {
                return fileChooserConfiguration;
            }

            public final String getLabel() {
                return "File:";
            }
        };
        SourceFilePanel sourceFilePanel = new SourceFilePanel(model.getFileModel(), configuration){

            protected final boolean performOpenFile(Component parentComponent, File file) {
                return Image2AsciiSourceImagePanel.this.performLoadImage(parentComponent, file);
            }
        };
        JPanel p = new JPanel(new BorderLayout(2, 2));
        p.add((Component)this.imagePanel.getContent(), "Center");
        p.add((Component)sourceFilePanel.createPanel(), "North");
        this.content = p;
    }

    private boolean performLoadImage(Component parentComponent, File file) {
        return new ImageOpenPerformer(this.model).performOpen(parentComponent, file);
    }

    public final JComponent getContent() {
        return this.content;
    }
}

