/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.preferences.ColorScheme;
import de.jave.javeplayer.AsciiPacker;
import de.jave.lib.BooleanPlate;
import java.awt.Point;

public final class CompressedDocumentState {
    private String selectionContent;
    private String selectionMask;
    private Point selectionLocation;
    private String content;
    private int scrollX;
    private int scrollY;
    private int cursorX;
    private int cursorY;
    private String toolName;
    private String actionName;
    private ColorScheme colorScheme;
    private int duration;

    CompressedDocumentState() {
    }

    public CompressedDocumentState(char[][] content, Point scrollOrigin, char[][] selectionContent, Point selectionLocation, BooleanPlate selectionMask, Point cursorLocation, String toolName, String actionName, ColorScheme colorScheme) {
        this.actionName = actionName;
        this.toolName = toolName;
        this.colorScheme = colorScheme;
        this.content = AsciiPacker.encode(content);
        this.selectionContent = selectionContent == null ? null : AsciiPacker.encode(selectionContent);
        this.selectionMask = selectionMask == null ? null : selectionMask.toString();
        if (scrollOrigin != null) {
            this.scrollX = scrollOrigin.x;
            this.scrollY = scrollOrigin.y;
        } else {
            this.scrollX = 0;
            this.scrollY = 0;
        }
        this.selectionLocation = selectionLocation == null ? null : new Point(selectionLocation.x, selectionLocation.y);
        if (cursorLocation != null) {
            this.cursorX = cursorLocation.x;
            this.cursorY = cursorLocation.y;
            return;
        }
        this.cursorX = 0;
        this.cursorY = 0;
    }

    public final void setTool(String tool) {
        this.toolName = tool;
    }

    public final void setAction(String action) {
        this.actionName = action;
    }

    public final String getAction() {
        return this.actionName;
    }

    public final void setContent(String content) {
        this.content = content;
    }

    public final void setSelectionContent(String selectionContent) {
        this.selectionContent = selectionContent;
    }

    public final void setDuration(int duration) {
        this.duration = duration;
    }

    public final void setSelectionMask(String selectionMask) {
        this.selectionMask = selectionMask;
    }

    public final void setColorScheme(ColorScheme colorScheme) {
        this.colorScheme = colorScheme;
    }

    public final ColorScheme getColorScheme() {
        return this.colorScheme;
    }

    public final void setScrollX(int scrollX) {
        this.scrollX = scrollX;
    }

    public final void setScrollY(int scrollY) {
        this.scrollY = scrollY;
    }

    public final void setCursorX(int cursorX) {
        this.cursorX = cursorX;
    }

    public final void setCursorY(int cursorY) {
        this.cursorY = cursorY;
    }

    public final int getCursorX() {
        return this.cursorX;
    }

    public final int getCursorY() {
        return this.cursorY;
    }

    public final void setSelectionLocation(int selectionX, int selectionY) {
        this.selectionLocation = new Point(selectionX, selectionY);
    }

    public final int getEstimatedMemorySize() {
        int result = 0;
        if (this.content != null) {
            result = 0 + this.content.length();
        }
        if (this.selectionContent != null) {
            result += this.selectionContent.length();
        }
        if (this.toolName != null) {
            result += this.toolName.length();
        }
        if (this.actionName != null) {
            result += this.toolName.length();
        }
        return result + 50;
    }

    public final String getUndoActionName() {
        return this.actionName;
    }

    public final char[][] getContent() {
        if (this.content == null) {
            return null;
        }
        return JaveAsciiPacker.decode(this.content);
    }

    public final Point getScrollOrigin() {
        return new Point(this.scrollX, this.scrollY);
    }

    public final int getScrollX() {
        return this.scrollX;
    }

    public final int getScrollY() {
        return this.scrollX;
    }

    public final String getPackedContent() {
        return this.content;
    }

    public final boolean hasSelection() {
        return this.selectionContent != null;
    }

    public final char[][] getSelectionContent() {
        if (this.selectionContent == null) {
            return null;
        }
        return JaveAsciiPacker.decode(this.selectionContent);
    }

    public final Point getSelectionLocation() {
        return this.selectionLocation;
    }

    public final boolean hasSelectionMask() {
        return this.selectionMask != null;
    }

    public final BooleanPlate getSelectionMask() {
        if (this.selectionMask == null) {
            return null;
        }
        return new BooleanPlate(this.selectionMask);
    }

    public final String getToolName() {
        return this.toolName;
    }

    public final Point getCursorLocation() {
        return new Point(this.cursorX, this.cursorY);
    }

    public final String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("J:");
        sb.append(this.content);
        sb.append('\n');
        sb.append("^:");
        sb.append(this.scrollX);
        sb.append(' ');
        sb.append(this.scrollY);
        sb.append('\n');
        sb.append("|:");
        sb.append(this.cursorX);
        sb.append(' ');
        sb.append(this.cursorY);
        sb.append('\n');
        sb.append("C:");
        sb.append(this.colorScheme.getColorHex());
        sb.append('\n');
        if (this.selectionContent != null) {
            sb.append("S:");
            sb.append(this.selectionLocation.x);
            sb.append(' ');
            sb.append(this.selectionLocation.y);
            sb.append(' ');
            sb.append(this.selectionContent);
            sb.append('\n');
            if (this.selectionMask != null) {
                sb.append("M:");
                sb.append(this.selectionMask);
                sb.append('\n');
            }
        }
        if (this.toolName != null) {
            sb.append("T:");
            sb.append(this.toolName);
            sb.append('\n');
        }
        if (this.actionName != null) {
            sb.append("A:");
            sb.append(this.actionName);
            sb.append('\n');
        }
        sb.append("+:");
        sb.append(this.duration);
        sb.append('\n');
        return sb.toString();
    }
}

