/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.GenericTool;
import de.jave.jave.Jave;
import de.jave.jave.Point2d;
import de.jave.jave.algorithm.fill.FillAlgorithm;
import de.jave.jave.algorithm.fill.FillMatchMode;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.rendering.PixelPlateRenderer;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public final class EllipseToolGeneric
extends GenericTool {
    private Point point1;
    private Point point2;
    private JCheckBox cbFill;

    public EllipseToolGeneric(JaveMainPanel mainPanel, Jave asciiPainter) {
        super(mainPanel, asciiPainter);
    }

    public final String getName() {
        return "Ellipse Generic";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/ellipse_generic.gif");
    }

    public final JComponent getAdditionalOptionsComponent() {
        if (this.cbFill == null) {
            this.cbFill = new JCheckBox("Fill", false);
        }
        return this.cbFill;
    }

    public final void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
    }

    public final void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.markPlate == null || this.point1 == null || this.point2 == null) {
            return;
        }
        g.setColor(colorScheme.getColorToolHelping());
        g.drawOval(this.point1.x - 1, this.point1.y - 1, 2, 2);
        Point point3 = EllipseToolGeneric.getQuadraticPointFor(this.point1, this.point2, shiftDown);
        Point2d origin = this.getPlate().getRealLocationForScreenPoint(this.point1);
        Point2d rp = this.getPlate().getRealLocationForScreenPoint(point3);
        double rX = rp.x - origin.x;
        double rY = rp.y - origin.y;
        this.markPlate.clear();
        rX = rX < 0.0 ? -rX : rX;
        rY = rY < 0.0 ? -rY : rY;
        boolean fill = this.cbFill.isSelected();
        this.markPlate.clear();
        if (fill && !this.isLineMode()) {
            this.markPlate.fillEllipse(origin.x, origin.y, rX, rY);
        } else {
            this.markPlate.drawEllipse(origin.x, origin.y, rX, rY);
        }
        this.markPlate.convert();
        if (fill && this.isLineMode() && rX >= 1.0 && rY >= 1.0) {
            FillAlgorithm.fillSolid(this.markPlate.getCharacterPlate(), (int)origin.x - this.markPlate.getOriginX(), (int)origin.y - this.markPlate.getOriginY(), '\u00a0', FillMatchMode.EQUAL_CHARACTER);
        }
        PixelPlateRenderer.paint(g, this.getPlate(), colorScheme, this.debug, this.markPlate, plateOrigin);
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        this.point1 = point;
        this.point2 = point;
        this.markPlate = new PixelPlate(location.x - 10, location.y - 10, 20, 20);
        pixelPlateOptionsPanel.configure(this.markPlate);
        this.markPlate.setCharacter(this.getMouseChar());
        this.repaintCursor();
    }

    public final void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.markPlate == null) {
            return;
        }
        this.setMixMode(this.isMix());
        this.markPlate.pasteResultInto(this.getPlate().getContent());
        this.point1 = null;
        this.point2 = null;
        this.markPlate = null;
        this.saveCurrentState("draw ellipse");
        this.repaintAll();
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.point1 == null || this.point2 == null || this.markPlate == null) {
            return;
        }
        if (point.equals(this.point2)) {
            return;
        }
        this.point2 = point;
        this.repaintCursor();
    }

    public final void keyPressed(int code, KeyEvent evt) {
        if (this.markPlate == null) {
            return;
        }
        if (code == 27 && this.markPlate != null) {
            this.markPlate = null;
            this.point1 = null;
            this.point2 = null;
            this.repaintCursor();
        }
    }
}

