/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.jave.FilterMatrix;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.lib.CharacterPlate;
import java.awt.Insets;

public final class Filter {
    private static final String[] FILTER_IMAGE2ASCII_SIMPLE_EDGE = new String[]{"7171", "?\\_____", "?``--..", "7171", "_____/?", ",,--''?", "5151", "\\____", "``--.", "5151", "____/", ",--''", "5151", "\\___?", "`--.?", "5151", "?___/", "?,--'", "3131", "\\__", "`-.", "3131", "__/", ",-'", "5131", "?\\___", "`-.", "5131", "___/?", ",-'", "5331", "???!??_/??!????", ",'?", "5331", "!?????\\_?????!?", "`.?", "3311", "_\\??\\\\?? ", "`", "3311", "?/_//? ??", "'"};
    private static final String[] FILTER_LINE_ART_CLEANER = new String[]{"3311", "?? ?/'???", ",", "3333", " ??'\\????", "???`.????", "3311", " ??`\\????", ".", "3311", "??,,-????", "'", "3311", "?| ?/? |?", "|", "3311", " |??\\??| ", "|", "3311", "?| ?/? '?", "|", "3311", "??_?, ???", "/", "3311", "??_.-????", "'", "3311", "? ?-| ?|?", ".", "3311", "_?? -.???", "`", "3311", "??_,-????", "'", "3333", "???'-_???", "???`.????", "3311", "  |?|?/ ?", "/", "3311", "??',- ???", "'", "3333", "? ' ' !??", "??/?/????", "3311", "?|?? .???", "`", "3311", "?|?- ????", "'", "3311", "?|?? -???", "`", "3311", "???? -?|?", ",", "3311", "???- ??|?", ".", "3311", "? ! ' ! ?", "/", "3333", "._ ? .???", "? ??`????", "3311", "\\?? -.???", "`", "3311", "??_ - '??", "/", "3311", "???`_???!", ".", "3311", "!  ?'!???", "`", "3333", "'.??\\????", "`???|????", "3333", "`.??\\????", "????|????", "3333", "?.'?/????", "????|????", "3311", "?,?/' ???", " ", "3311", ".?  -. ??", "`", "3311", "   ?|'?!?", ",", "3311", "!?  -  ?!", "\\", "3311", "?_?''????", " ", "5533", "??????? _! _- ?!?????????", "???,'????", "3311", "  /?\\ ???", "(", "3311", "???`- ??\\", ".", "3311", " ?? !'!  ", ",", "3311", "!   !   !", "\\", "3311", "  ! ! !  ", "/", "3311", "   _!,   ", ",", "3333", "  !_-    ", "???,'????", "3311", "?? `-_ ??", ".", "3311", "?  ?/-? ?", ",", "3311", "  ?-\\?? ?", ".", "3311", "?!? '\\???", " ", "3311", "    !_ | ", ",", "3311", "?|?/! ?  ", " ", "3311", "? !,- ?  ", "'", "3311", "?  !` ? !", ".", "3311", "?? -- ??\\", ".", "3333", " _,- ?? ?", "? ??'????", "3311", " !? \\.?? ", "`", "3311", "!??`\\????", ".", "3311", "?! ,/?? ??", "'", "3311", " ?? --!??", ",", "5533", "??????! ??? -_ ?? ?!?????", "????`.???", "3311", "???!_ ?\\?", " ", "5511", "??????????? _-'?!????????", ","};
    private static final String[] FILTER_POST = new String[]{"7553", "??????????????--\\???????\\--????????", "?????._?????''?", "7553", "?????????????????/--?--/???????????", "???????_.?''???", "5533", "?????-\\?????\\-????????????", ".???'????", "5533", "???????/-?-/?????????????", "?,?'?????", "5533", "?????-\\?????\\\\?????\\?????", ".???`.???", "5533", "?????????/??//?-/????????", "????,''??", "5533", "????????/-?//??/?????????", "??,,'????", "5533", "?????\\?????\\\\?????\\-?????", "???`.???'", "5533", "?!?????\\????\\?????!??????", "?:??:????", "5533", "???!???/????/???!????????", "?;??;????", "5533", "????????!??//??!?????????", "???,'????", "5533", "?????!?????\\\\?????!??????", "???`.????", "3311", "???\\-/???", "_", "3333", "???/-\\???", "?_?? ????", "3311", "?!??\\???!", ":", "3311", "??!?/??!?", ";", "3311", "!???\\??!?", ":", "3311", "?!??/?!??", ";", "3311", "!???\\-???", "`", "3311", "??!-/????", "'", "3311", "???-\\???!", ".", "3311", "????/-!??", ",", "3311", "??!?< ??!", "(", "3311", "!?? >?!??", ")", "3311", "!?!?V????", "'", "3311", "????^?!?!", "."};
    private static final String[] FILTER_PRE = new String[]{"3311", "  ? ##?#?", " ", "3311", "?#?## ?  ", " ", "3311", "?  ## ?#?", " ", "3311", "?#? ##  ?", " "};
    private static final String[] FILTER_MID = new String[]{"3311", "????#!?!?", "+", "3311", "???!#??!?", "+", "3311", "?!?!#????", "+", "3311", "?!??#!???", "+", "3311", "  ??#!  ?", "-", "3311", "?  !#??  ", "-", "3311", "? ?!#!? ?", "-", "3311", "?!? #  ? ", "|", "3311", " ?  # ?!?", "|", "3311", "?!? # ?!?", "|", "3311", "! ! # ! !", "X", "3311", "  ! #?  !", "<", "3311", "!  ?# !  ", ">", "3311", "!?! #    ", "V", "3311", "    # !?!", "^", "3311", "! !?#??!?", "|", "3311", "?!??#?! !", "|", "3311", "????# ? !", "\\", "3311", "??? #?! ?", "/", "3311", "! ? #????", "\\", "3311", "? !?# ???", "/", "3311", "    #    ", "+"};
    private static FilterMatrix[] filterPost;
    private static FilterMatrix[] filterPre;
    private static FilterMatrix[] filterMid;
    private static FilterMatrix[] filterLineArtCleaner;
    private static FilterMatrix[] filterImage2asciiSimpleEdge;
    private static boolean initialized;

    public static final void init() {
        int i;
        if (initialized) {
            return;
        }
        initialized = true;
        filterPost = new FilterMatrix[FILTER_POST.length / 3];
        for (i = 0; i < FILTER_POST.length / 3; ++i) {
            Filter.filterPost[i] = new FilterMatrix(FILTER_POST[i * 3], FILTER_POST[i * 3 + 1], FILTER_POST[i * 3 + 2]);
        }
        filterPre = new FilterMatrix[FILTER_PRE.length / 3];
        for (i = 0; i < FILTER_PRE.length / 3; ++i) {
            Filter.filterPre[i] = new FilterMatrix(FILTER_PRE[i * 3], FILTER_PRE[i * 3 + 1], FILTER_PRE[i * 3 + 2]);
        }
        filterMid = new FilterMatrix[FILTER_MID.length / 3];
        for (i = 0; i < FILTER_MID.length / 3; ++i) {
            Filter.filterMid[i] = new FilterMatrix(FILTER_MID[i * 3], FILTER_MID[i * 3 + 1], FILTER_MID[i * 3 + 2]);
        }
        filterLineArtCleaner = new FilterMatrix[FILTER_LINE_ART_CLEANER.length / 3];
        for (i = 0; i < FILTER_LINE_ART_CLEANER.length / 3; ++i) {
            Filter.filterLineArtCleaner[i] = new FilterMatrix(FILTER_LINE_ART_CLEANER[i * 3], FILTER_LINE_ART_CLEANER[i * 3 + 1], FILTER_LINE_ART_CLEANER[i * 3 + 2]);
        }
        filterImage2asciiSimpleEdge = new FilterMatrix[FILTER_IMAGE2ASCII_SIMPLE_EDGE.length / 3];
        for (i = 0; i < FILTER_IMAGE2ASCII_SIMPLE_EDGE.length / 3; ++i) {
            Filter.filterImage2asciiSimpleEdge[i] = new FilterMatrix(FILTER_IMAGE2ASCII_SIMPLE_EDGE[i * 3], FILTER_IMAGE2ASCII_SIMPLE_EDGE[i * 3 + 1], FILTER_IMAGE2ASCII_SIMPLE_EDGE[i * 3 + 2]);
        }
    }

    private static void filter(CharacterPlate cp, FilterMatrix[] filter) {
        int h = cp.getHeight();
        int w = cp.getWidth();
        int[][] raster = new int[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (cp.get(x, y) == ' ') continue;
                for (int yy = y - 1; yy <= y + 1; ++yy) {
                    for (int xx = x - 1; xx <= x + 1; ++xx) {
                        if (yy < 0 || yy >= h || xx < 0 || xx >= w) continue;
                        int[] nArray = raster[yy];
                        int n = xx;
                        nArray[n] = nArray[n] + 1;
                    }
                }
            }
        }
        for (int y = 0; y < h; ++y) {
            block5: for (int x = 0; x < w; ++x) {
                if (raster[y][x] == 0) continue;
                for (int f = 0; f < filter.length; ++f) {
                    if (!filter[f].fits(cp, w, h, x, y, raster[y][x])) continue;
                    filter[f].apply(cp, w, h, x, y);
                    continue block5;
                }
            }
        }
    }

    private static void filterQuick(CharacterPlate cp, FilterMatrix[] filter) {
        int h = cp.getHeight();
        int w = cp.getWidth();
        for (int y = 0; y < h; ++y) {
            block1: for (int x = 0; x < w; ++x) {
                if (cp.get(x, y) != '#') continue;
                for (int f = 0; f < filter.length; ++f) {
                    if (!filter[f].fits(cp, w, h, x, y, -1)) continue;
                    filter[f].apply(cp, w, h, x, y);
                    continue block1;
                }
            }
        }
    }

    private static void cleanUp(CharacterPlate cp) {
        GeneralAlgorithm.replace(cp, '#', ' ');
    }

    public static final void filter(CharacterPlate characterPlate, int mode) {
        int originalWidth = characterPlate.getWidth();
        int originalHeight = characterPlate.getHeight();
        Insets emptyInsets = characterPlate.getEmptyInsets();
        boolean originX = false;
        boolean originY = false;
        int newWidth = originalWidth + 2 - emptyInsets.left - emptyInsets.right;
        int newHeight = originalHeight + 2 - emptyInsets.top - emptyInsets.bottom;
        if (newWidth <= 0 || newHeight <= 0) {
            return;
        }
        CharacterPlate tp = new CharacterPlate(newWidth, newHeight);
        characterPlate.getCopy(emptyInsets.left, emptyInsets.top, newWidth - 1, newHeight - 1).pasteInto(tp, 1, 1);
        switch (mode) {
            case 0: {
                Filter.filterQuick(tp, filterPre);
                Filter.filterQuick(tp, filterMid);
                Filter.cleanUp(tp);
                Filter.filter(tp, filterPost);
                break;
            }
            case 1: {
                Filter.filterQuick(tp, filterPre);
                Filter.filterQuick(tp, filterMid);
                Filter.cleanUp(tp);
                break;
            }
            case 2: {
                Filter.filter(tp, filterLineArtCleaner);
                break;
            }
            case 3: {
                Filter.filter(tp, filterImage2asciiSimpleEdge);
            }
        }
        tp.pasteIntoForce(characterPlate, emptyInsets.left - 1, emptyInsets.top - 1);
    }

    static {
        initialized = false;
        String[] stringArray = new String[]{"Soft rounded", "middle"};
    }
}

