/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.dialog.GDialog;
import de.jave.jave.Jave;
import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.JaveAlgorithmOptionsPanel;
import de.jave.jave.algorithm.JaveOptionsAlgorithm;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.fontchooser.model.FontModel;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public final class JaveOptionsAlgorithmDialog {
    private final Jave jave;
    private JaveSelection source;
    private boolean applied = false;
    private JaveOptionsAlgorithm algorithm;
    private final JDialog dialog;

    public JaveOptionsAlgorithmDialog(Jave parent, JaveOptionsAlgorithm algorithm, FontModel fontModel) {
        this.dialog = GDialog.createJDialog(parent.getFrame(), algorithm.getMenuItemLabel(), true);
        this.jave = parent;
        this.algorithm = algorithm;
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                JaveOptionsAlgorithmDialog.this.performCancel();
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.source = this.jave.getContentOfInterest();
        algorithm.getOptions().adjustTo(this.source);
        JaveAlgorithmOptionsPanel optionsPanel = algorithm.getOptions().getPanel(fontModel);
        ButtonPanelBuilder builder = new ButtonPanelBuilder();
        builder.add(new SmartAction("OK"){

            protected final void execute(Component parentComponent) {
                JaveOptionsAlgorithmDialog.this.performOk();
            }
        });
        builder.add(new SmartAction("Cancel"){

            protected final void execute(Component parentComponent) {
                JaveOptionsAlgorithmDialog.this.performCancel();
            }
        });
        this.dialog.getContentPane().add((Component)optionsPanel.getContent(), "Center");
        this.dialog.getContentPane().add((Component)builder.createPanel(), "South");
        this.dialog.pack();
        GuiUtilities.centerToParent(this.dialog);
        algorithm.getOptions().addAlgorithmOptionsListener(this);
    }

    public final void algorithmOptionsChanged() {
        JaveSelection sel = this.algorithm.apply(this.source.getClone());
        this.jave.setContentOfInterest(sel);
        this.applied = true;
    }

    private void performOk() {
        this.algorithm.getOptions().removeAlgorithmOptionsListener(this);
        if (this.applied) {
            this.jave.saveCurrentState(this.algorithm.getActionName());
        }
        this.applied = false;
        this.dialog.setVisible(false);
    }

    private void performCancel() {
        this.algorithm.getOptions().removeAlgorithmOptionsListener(this);
        if (this.applied) {
            this.jave.setContentOfInterest(this.source);
            this.applied = false;
        }
        this.dialog.setVisible(false);
    }

    public final void show() {
        this.dialog.setVisible(true);
    }
}

