/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.asciimation.JmovFileChooserConfiguration;
import de.jave.gui.io.FileChooserUtilities;
import de.jave.gui.layout.Gap;
import de.jave.jave.AsciiGradients;
import de.jave.jave.DialogTool;
import de.jave.jave.Jave;
import de.jave.jave.JaveAsciiPacker;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.Polygon2d;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateMode;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.lib.CharacterPlate;
import de.jave.lib.Toolbox;
import de.jave.lib.gui.GuiUtilities;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.layout.grid.GridDialogLayout;

public final class Render3DTool
extends DialogTool
implements ItemListener,
KeyListener,
ActionListener {
    private Button bLeft;
    private Button bRight;
    private Button bIn;
    private Button bOut;
    private Button bReset;
    private Button bAnimation;
    private JComboBox chDemo;
    private JComboBox chStyle;
    private JComboBox tfGradient;
    private static final String[] STYLES = new String[]{"Solid", "Wireframe", "High Resolution", "Shaded"};
    private JTextArea taScript;
    private int alpha = 0;
    private double zoom = 7.0;
    private static final String[] DEMOS_TITLES = new String[]{"Pyramid", "Cube", "JavE Logo", "Key"};
    private static final String[] DEMOS_CONTENTS = new String[]{"#Simple Pryramid demo - by Markus Gebhard 2001\n#This script has to contain two parts:\n# 1) List of vertices (3 float values, coordinates)\n# 2) List of polygons (3,4,... integer values, vertex indices)\n#Lines that do not fit this scheme are being ignored w/o warning!\n#\n#list of vertices:\n# x    y    z   \n 1.0 -1.0  1.0\n 1.0 -1.0 -1.0\n-1.0 -1.0  1.0\n-1.0 -1.0 -1.0\n 0.0  1.0  0.0\n\n#list of  polygons:\n 0 2 4 \n 0 1 4 \n 1 3 4 \n 2 3 4 \n 0 1 3 2 \n", "#Simple Cube demo - by Markus Gebhard 2001\n#This script has to contain two parts:\n# 1) List of vertices (3 float values, coordinates)\n# 2) List of polygons (3,4,... integer values, vertex indices)\n#Lines that do not fit this scheme are being ignored w/o warning!\n#\n#list of vertices:\n# x    y    z   \n 1.0  1.0  1.0\n-1.0  1.0  1.0\n 1.0 -1.0  1.0\n 1.0  1.0 -1.0\n 1.0 -1.0 -1.0\n-1.0 -1.0  1.0\n-1.0  1.0 -1.0\n-1.0 -1.0 -1.0\n\n#list of polygons:\n 0 1 5 2 \n 0 1 6 3 \n 0 3 4 2 \n 2 5 7 4 \n 1 6 7 5 \n 3 6 7 4 \n", "#Jave Logo - by Markus Gebhard 2001\n# list of vertices:\n# x    y    z   \n\n#(descriptions in german!)\n#Vordere a-Koordinaten\n -.3   .1   -.2\n -.3   .3   -.2\n -.2   .4   -.2\n  .2   .4   -.2\n  .3   .3   -.2\n  .3  -.4   -.2\n -.2  -.4   -.2\n -.3  -.3   -.2\n -.3   0    -.2\n -.2   .1   -.2\n  .1   .1   -.2\n  .1  -.1   -.2\n -.1  -.1   -.2\n -.1  -.2   -.2\n  .1  -.2   -.2\n  .1   .2   -.2\n -.2   .2   -.2\n \n#Hintere a-Koordinaten\n -.3   .1   .2\n -.3   .3   .2\n -.2   .4   .2\n  .2   .4   .2\n  .3   .3   .2\n  .3  -.4   .2\n -.2  -.4   .2\n -.3  -.3   .2\n -.3   0    .2\n -.2   .1   .2\n  .1   .1   .2\n  .1  -.1   .2\n -.1  -.1   .2\n -.1  -.2   .2\n  .1  -.2   .2\n  .1   .2   .2\n -.2   .2   .2\n\n\n#Diagonaler Strich links oben\n -.8 .7 0\n -.7 .8 0\n -.4 .5 0\n -.5 .4 0\n -.8 .7 .3\n -.7 .8 .3\n -.4 .5 .3\n -.5 .4 .3\n\n#Diagonaler Strich rechts oben\n  .8 .7 0\n  .7 .8 0\n  .4 .5 0\n  .5 .4 0\n  .8 .7 .3\n  .7 .8 .3\n  .4 .5 .3\n  .5 .4 .3\n\n#Diagonaler Strich links unten\n -.8 -.7 0\n -.7 -.8 0\n -.4 -.5 0\n -.5 -.4 0\n -.8 -.7 .3\n -.7 -.8 .3\n -.4 -.5 .3\n -.5 -.4 .3\n\n#Diagonaler Strich rechts unten\n  .8 -.7 0\n  .7 -.8 0\n  .4 -.5 0\n  .5 -.4 0\n  .8 -.7 .3\n  .7 -.8 .3\n  .4 -.5 .3\n  .5 -.4 .3\n\n#Waagrechter Strich oben\n  .3 .72 0\n  .3 .58 0\n -.3 .58 0\n -.3 .72 0\n  .3 .72 .3\n  .3 .58 .3\n -.3 .58 .3\n -.3 .72 .3\n\n#Waagrechter Strich unten\n  .3 -.72 0\n  .3 -.58 0\n -.3 -.58 0\n -.3 -.72 0\n  .3 -.72 .3\n  .3 -.58 .3\n -.3 -.58 .3\n -.3 -.72 .3\n\n#Senkrechter Strich rechts\n .72  .3  0\n .58  .3  0\n .58 -.3  0\n .72 -.3  0\n .72  .3  .3\n .58  .3  .3\n .58 -.3  .3\n .72 -.3  .3\n#Senkrechter Strich links\n -.72  .3  0\n -.58  .3  0\n -.58 -.3  0\n -.72 -.3  0\n -.72  .3  .3\n -.58  .3  .3\n -.58 -.3  .3\n -.72 -.3  .3\n\n##a Vorderseite\n 0  1  2  3  4  5  6  7  8  9 10 11 12 13 14 15 16\n##a R\u00fcckseite \n17 18 19 20 21 22 23 24 25 26 27 28 29 30 31 32 33\n\n#Diagonaler Strich links oben\n 34 35 36 37\n 38 39 40 41\n 38 34 35 39\n 39 35 36 40\n 40 36 37 41\n 41 37 34 38\n\n#Diagonaler Strich rechts oben (+8)\n 42 43 44 45\n 46 47 48 49\n 46 42 43 47\n 47 43 44 48\n 48 44 45 49\n 49 45 42 46\n\n#Diagonaler Strich links unten (+8)\n 50 51 52 53\n 54 55 56 57\n 54 50 51 55\n 55 51 52 56\n 56 52 53 57\n 57 53 50 54\n\n#Diagonaler Strich rechts unten (+8)\n 58 59 60 61\n 62 63 64 65\n 62 58 59 63\n 63 59 60 64\n 64 60 61 65\n 65 61 58 62\n\n#Waagrechter Strich oben (+8)\n 66 67 68 69\n 70 71 72 73\n 70 66 67 71\n 71 67 68 72\n 72 68 69 73\n 73 69 66 70\n\n#Waagrechter Strich unten (+8)\n 74 75 76 77\n 78 79 80 81\n 78 74 75 79\n 79 75 76 80\n 80 76 77 81\n 81 77 74 78\n\n#Senkrechter Strich rechts (+8)\n 82 83 84 85\n 86 87 88 89\n 86 82 83 87\n 87 83 84 88\n 88 84 85 89\n 89 85 82 86\n\n#Senkrechter Strich links (+8)\n 90 91 92 93\n 94 95 96 97\n 94 90 91 95\n 95 91 92 96\n 96 92 93 97\n 97 93 90 94\n\n#Seitenteile fuer das a zur Verbindung Vorder-/R\u00fcckseite\n 0 17 18  1\n 1 18 19  2\n 2 19 20  3\n 3 20 21  4\n 4 21 22  5\n 5 22 23  6\n 6 23 24  7\n 7 24 25  8\n 8 25 26  9\n 9 26 27 10\n10 27 28 11\n11 28 29 12\n12 29 30 13\n13 30 31 14\n14 31 32 15\n15 32 33 16\n16 33 17  0", "  #Basic Skeleton Key - by Adam Robbins 2004\n  #I Made this to try my hand at the 3D Rendering\n  #I wanted something more complex then a cube\n  #so that I could have a better understanding\n  #of how to do this. Mad props go out to the\n  #creator of JavE. Nice Job, would like more\n  #options for it but all in all a nice prog.\n  # http://www.geocities.com/adam007bond\n\n  #\n  #list of vertices:\n  #\n  # x    y    z\n  -2    0.125    0.0625\n  1.125    0.125    0.0625\n  1.375    0.625    0.0625\n  1.9375    0.625    0.0625\n  2.1875    0.125    0.0625\n  2.1875    -0.25    0.0625\n  1.9375    -0.75    0.0625\n  1.375    -0.75    0.0625\n  1.125    -0.25    0.0625\n  1.125    -0.125    0.1875\n  1.375    -0.125    0.0625\n  1.375    -0.25    0.0625\n  1.5    -0.5    0.0625\n  1.8125    -0.5    0.0625\n  1.9375    -0.25    0.0625\n  1.9375    0.125    0.0625\n  1.8125    0.375    0.0625\n  1.5    0.375    0.0625\n  1.375    0.125    0.0625\n  1.375    0    0.0625\n  1.125    0    0.1875\n  -2    0    0.1875\n  -2    -0.125    0.1875\n  -2    -0.25    0.0625\n  -1.375    -0.25    0.0625\n  -1.375    -0.625    0.0625\n  -2    -0.625    0.0625\n  -2    -1    0.0625\n  -1.875    -1    0.0625\n  -1.875    -0.8125    0.0625\n  -1.625    -0.8125    0.0625\n  -1.625    -1    0.0625\n  -1.375    -1    0.0625\n  -1.375    -0.8125    0.0625\n  -1.125    -0.8125    0.0625\n  -1.125    -1    0.0625\n  -0.875    -1    0.0625\n  -0.875    -0.8125    0.0625\n  -0.625    -0.8125    0.0625\n  -0.625    -1    0.0625\n  -0.5    -1    0.0625\n  -0.5    -0.625    0.0625\n  -1.125    -0.625    0.0625\n  -1.125    -0.25    0.0625\n  -2    0.125    -0.0625\n  1.125    0.125    -0.0625\n  1.375    0.625    -0.0625\n  1.9375    0.625    -0.0625\n  2.1875    0.125    -0.0625\n  2.1875    -0.25    -0.0625\n  1.9375    -0.75    -0.0625\n  1.375    -0.75    -0.0625\n  1.125    -0.25    -0.0625\n  1.125    -0.125    -0.1875\n  1.375    -0.125    -0.0625\n  1.375    -0.25    -0.0625\n  1.5    -0.5    -0.0625\n  1.8125    -0.5    -0.0625\n  1.9375    -0.25    -0.0625\n  1.9375    0.125    -0.0625\n  1.8125    0.375    -0.0625\n  1.5    0.375    -0.0625\n  1.375    0.125    -0.0625\n  1.375    0    -0.0625\n  1.125    0    -0.1875\n  -2    0    -0.1875\n  -2    -0.125    -0.1875\n  -2    -0.25    -0.0625\n  -1.375    -0.25    -0.0625\n  -1.375    -0.625    -0.0625\n  -2    -0.625    -0.0625\n  -2    -1    -0.0625\n  -1.875    -1    -0.0625\n  -1.875    -0.8125    -0.0625\n  -1.625    -0.8125    -0.0625\n  -1.625    -1    -0.0625\n  -1.375    -1    -0.0625\n  -1.375    -0.8125    -0.0625\n  -1.125    -0.8125    -0.0625\n  -1.125    -1    -0.0625\n  -0.875    -1    -0.0625\n  -0.875    -0.8125    -0.0625\n  -0.625    -0.8125    -0.0625\n  -0.625    -1    -0.0625\n  -0.5    -1    -0.0625\n  -0.5    -0.625    -0.0625\n  -1.125    -0.625    -0.0625\n  -1.125    -0.25    -0.0625\n\n  #\n  #list of  polygons:\n  #\n  #Side One:\n  1 19 20\n  9 10 8\n  0 1 20 21\n  9 20 19 10\n  21 20 9 22\n  22 9 8 23\n  1 2 3 4 5 6 7 8 10 11 12 13 14 15 16 17 18 19\n  24 43 42 41 40 39 38 37 36 35 34 33 32 31 30 29 28 27 26 25\n\n  #Side Two:\n  45 63 64\n  53 54 52\n  44 45 64 65\n  53 64 63 54\n  65 64 53 66\n  66 53 52 67\n  45 46 47 48 49 50 51 52 54 55 56 57 58 59 60 61 62 63\n  68 87 86 85 84 83 82 81 80 79 78 77 76 75 74 73 72 71 70 69\n\n  #Outside Edging:\n  44 65 66 67 23 22 21 0\n  45 44 0 1\n  46 45 1 2\n  47 46 2 3\n  48 47 3 4\n  49 48 4 5\n  50 49 5 6\n  51 50 6 7\n  52 51 7 8\n  87 52 8 43\n  86 87 43 42\n  85 86 42 41\n  84 85 41 40\n  83 84 40 39\n  82 83 39 38\n  81 82 38 37\n  80 81 37 36\n  79 80 36 35\n  78 79 35 34\n  77 78 34 33\n  76 77 33 32\n  75 76 32 31\n  74 75 31 30\n  73 74 30 29\n  72 73 29 28\n  71 72 28 27\n  70 71 27 26\n  69 70 26 25\n  68 69 25 24\n  67 68 24 23\n\n  #Inside Edging:\n  54 63 19 10\n  55 54 10 11\n  56 55 11 12\n  57 56 12 13\n  58 57 13 14\n  59 58 14 15\n  60 59 15 16\n  61 60 16 17\n  62 61 17 18\n  63 62 18 19\n"};

    public Render3DTool(Jave asciiPainter, JaveApplicationPreferences preferences) {
        super(asciiPainter, preferences);
        this.render();
        this.getDialog().addKeyListener(this);
    }

    protected final ColorScheme getPreferredColorScheme() {
        return ColorScheme.WHITE_ON_BLACK;
    }

    protected final String getToolTitle() {
        return "3D Rendering Tool";
    }

    public final String getToolActionName() {
        return "render 3D";
    }

    public final Component getOptionsComponent() {
        this.taScript = new JTextArea(DEMOS_CONTENTS[0], 9, 40);
        this.taScript.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                Render3DTool.this.render();
            }
        });
        this.taScript.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.bAnimation = new Button("Save Animation");
        this.bAnimation.addActionListener(this);
        JPanel pNavigation = new JPanel();
        pNavigation.setBorder(BorderFactory.createTitledBorder("Navigation"));
        this.bLeft = new Button("Rotate left");
        this.bLeft.addActionListener(this);
        pNavigation.add(this.bLeft);
        this.bRight = new Button("Rotate right");
        this.bRight.addActionListener(this);
        pNavigation.add(this.bRight);
        this.bOut = new Button("Zoom Out");
        this.bOut.addActionListener(this);
        pNavigation.add(this.bOut);
        this.bIn = new Button("Zoom In");
        this.bIn.addActionListener(this);
        pNavigation.add(this.bIn);
        this.bReset = new Button("Reset");
        this.bReset.addActionListener(this);
        pNavigation.add(this.bReset);
        pNavigation.add(new Gap());
        pNavigation.add(this.bAnimation);
        this.chDemo = new JComboBox<String>(DEMOS_TITLES);
        this.chDemo.addItemListener(this);
        this.chStyle = new JComboBox<String>(STYLES);
        this.chStyle.addItemListener(this);
        this.tfGradient = AsciiGradients.createComponent();
        this.tfGradient.addActionListener(new ActionListener(){

            public final void actionPerformed(ActionEvent e) {
                Render3DTool.this.render();
            }
        });
        JPanel pControls = new JPanel(new GridDialogLayout(6, false));
        pControls.add(new JLabel("Demos:"));
        pControls.add(this.chDemo);
        pControls.add(new JLabel("Style:"));
        pControls.add(this.chStyle);
        pControls.add(new JLabel("Gradient:"));
        pControls.add(this.tfGradient);
        JPanel p = new JPanel(new BorderLayout(2, 2));
        p.add((Component)pNavigation, "North");
        p.add((Component)pControls, "South");
        p.add((Component)new JScrollPane(this.taScript), "Center");
        p.addKeyListener(this);
        pControls.addKeyListener(this);
        pNavigation.addKeyListener(this);
        this.bLeft.addKeyListener(this);
        this.bRight.addKeyListener(this);
        this.bOut.addKeyListener(this);
        this.bIn.addKeyListener(this);
        this.tfGradient.setEnabled(this.chStyle.getSelectedIndex() == 3);
        return p;
    }

    private void doRotateLeft() {
        this.alpha -= 5;
        this.render();
    }

    private void doRotateRight() {
        this.alpha += 5;
        this.render();
    }

    private void doZoomIn() {
        this.zoom *= 1.2;
        this.render();
    }

    private void doZoomOut() {
        this.zoom *= 0.8333333333333334;
        this.render();
    }

    public final void keyReleased(KeyEvent evt) {
    }

    public final void keyTyped(KeyEvent evt) {
    }

    public final void keyPressed(KeyEvent evt) {
        int code = evt.getKeyCode();
        if (code == 37) {
            this.doRotateLeft();
            evt.consume();
            return;
        }
        if (code == 39) {
            this.doRotateRight();
            evt.consume();
            return;
        }
        if (code == 38) {
            this.doZoomIn();
            evt.consume();
            return;
        }
        if (code == 40) {
            this.doZoomOut();
            evt.consume();
            return;
        }
    }

    public final void actionPerformed(ActionEvent evt) {
        Window parentComponent = GuiUtilities.getWindowForComponent(evt);
        Object source = evt.getSource();
        if (source == this.bReset) {
            this.alpha = 0;
            this.zoom = 7.0;
            this.render();
            return;
        }
        if (source == this.bLeft) {
            this.doRotateLeft();
            return;
        }
        if (source == this.bRight) {
            this.doRotateRight();
            return;
        }
        if (source == this.bIn) {
            this.doZoomIn();
            return;
        }
        if (source == this.bOut) {
            this.doZoomOut();
            return;
        }
        if (source == this.bAnimation) {
            this.animate(parentComponent);
            return;
        }
    }

    protected final void render() {
        if (this.markPlate == null) {
            this.markPlate = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
        }
        double dx = this.plateWidth / 2;
        double dy = this.plateHeight / 2;
        int style = this.chStyle.getSelectedIndex();
        String gradient = (String)this.tfGradient.getSelectedItem();
        if (gradient.length() == 0) {
            gradient = " ";
        }
        Render3DTool.render(this.markPlate, this.taScript.getText(), style, gradient, this.alpha, 3.0, this.zoom, dx, dy);
        this.characterPlate.clear();
        this.markPlate.convert();
        this.markPlate.pasteResultInto(this.characterPlate);
        this.repaintPlate();
    }

    public static final void render(PixelPlate markPlate, String script, int style, String gradient, double alpha, double d, double scale, double dx, double dy) {
        int y;
        switch (style) {
            case 2: {
                markPlate.setMode(PixelPlateMode.PIXEL);
                break;
            }
            case 0: 
            case 1: {
                markPlate.setMode(PixelPlateMode.DOT);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                markPlate.setMode(PixelPlateMode.CHAR);
            }
        }
        markPlate.clear();
        double scaleX = scale * 1.98;
        double scaleY = scale;
        int vWidth = markPlate.getVirtualWidth();
        int vHeight = markPlate.getVirtualHeight();
        double factorX = vWidth / markPlate.getWidth();
        double factorY = vHeight / markPlate.getHeight();
        double[][] zBuffer = new double[vHeight][vWidth];
        for (int x = 0; x < vWidth; ++x) {
            zBuffer[0][x] = Double.MAX_VALUE;
        }
        for (int y2 = 1; y2 < vHeight; ++y2) {
            System.arraycopy(zBuffer[0], 0, zBuffer[y2], 0, vWidth);
        }
        int[][] markBuffer = new int[vHeight][vWidth];
        boolean mode = false;
        Vector<double[]> points = new Vector<double[]>();
        Vector<Integer> shades = new Vector<Integer>();
        StringTokenizer st = new StringTokenizer(script, "\n", false);
        int polCounter = 0;
        while (st.hasMoreTokens()) {
            StringTokenizer sl;
            String line = st.nextToken().trim();
            if (line.length() == 0 || line.charAt(0) == '#' || line.startsWith("AlWuzEre")) continue;
            if (!mode && line.indexOf(46) == -1 && line.indexOf(45) == -1) {
                mode = true;
            }
            if (!mode) {
                try {
                    sl = new StringTokenizer(line, " \t", false);
                    double x1 = Double.valueOf(sl.nextToken());
                    double y1 = Double.valueOf(sl.nextToken());
                    double z1 = Double.valueOf(sl.nextToken());
                    double[] p = Render3DTool.transform(x1, y1, z1, alpha, d, scaleX, scaleY, dx, dy);
                    points.addElement(p);
                }
                catch (Exception exception) {
                    System.err.println("Warning: Line '" + line + "' seems to be invalid. - ignored");
                }
                continue;
            }
            try {
                int iAngle;
                double d2;
                int i;
                ++polCounter;
                sl = new StringTokenizer(line, " \t", false);
                int count = sl.countTokens();
                int[] polygon = new int[count];
                for (i = 0; i < count; ++i) {
                    polygon[i] = Integer.parseInt(sl.nextToken());
                }
                if (style == 1) {
                    for (i = 0; i < count; ++i) {
                        double[] p0 = (double[])points.elementAt(polygon[i]);
                        double[] p1 = (double[])points.elementAt(polygon[(i + 1) % count]);
                        markPlate.drawLine(p0[0] + dx, p0[1] + dy, p1[0] + dx, p1[1] + dy);
                    }
                    continue;
                }
                double[] polX = new double[count];
                double[] polY = new double[count];
                for (int i2 = 0; i2 < count; ++i2) {
                    double[] p = (double[])points.elementAt(polygon[i2]);
                    polX[i2] = p[0] * factorX;
                    polY[i2] = p[1] * factorY;
                }
                Polygon2d pol2 = new Polygon2d(polX, polY);
                double[] p0 = (double[])points.elementAt(polygon[0]);
                double[] p1 = (double[])points.elementAt(polygon[1]);
                double[] p2 = (double[])points.elementAt(polygon[2]);
                double ax = p0[3] - p1[3];
                double ay = p0[4] - p1[4];
                double az = p0[2] - p1[2];
                double bx = p2[3] - p1[3];
                double by = p2[4] - p1[4];
                double bz = p2[2] - p1[2];
                double nx = ay * bz - az * by;
                double ny = az * bx - ax * bz;
                double nz = ax * by - ay * bx;
                double e = Math.sqrt(nx * nx + ny * ny + nz * nz);
                nx /= e;
                ny /= e;
                nz /= e;
                ax = p0[5] - p1[5];
                ay = p0[6] - p1[6];
                az = p0[7] - p1[7];
                bx = p2[5] - p1[5];
                by = p2[6] - p1[6];
                bz = p2[7] - p1[7];
                double lnx = ay * bz - az * by;
                double lny = az * bx - ax * bz;
                double lnz = ax * by - ay * bx;
                e = Math.sqrt(lnx * lnx + lny * lny + lnz * lnz);
                lnx /= e;
                lny /= e;
                lnz /= e;
                double lx = 0.0;
                double ly = -1.0;
                double lz = 2.0;
                e = Math.sqrt(1.0 + 1.0 + lz * lz);
                lx = 1.0 / e;
                double cosAlpha = lx * lnx + (ly /= e) * lny + (lz /= e) * lnz;
                double angle = 57.29577951308232 * Math.acos(cosAlpha);
                if (d2 > 90.0) {
                    angle = 180.0 - angle;
                }
                if ((iAngle = (int)(angle / 90.0 * (double)gradient.length())) >= gradient.length()) {
                    iAngle = gradient.length() - 1;
                }
                shades.addElement(new Integer(iAngle));
                double px = p0[3] - 0.0;
                double py = p0[4] - 0.0;
                double pz = p0[2] + d;
                int minY = (int)(pol2.minY + dy * factorY) - 1;
                int maxY = (int)(pol2.maxY + dy * factorY) + 1;
                int minX = (int)(pol2.minX + dx * factorX) - 1;
                int maxX = (int)(pol2.maxX + dx * factorX) + 1;
                if (minY < 0) {
                    minY = 0;
                }
                if (minX < 0) {
                    minX = 0;
                }
                if (maxX >= vWidth) {
                    maxX = vWidth - 1;
                }
                if (maxY >= vHeight) {
                    maxY = vHeight - 1;
                }
                for (int y3 = minY; y3 <= maxY; ++y3) {
                    for (int x = minX; x <= maxX; ++x) {
                        double d3;
                        if (!pol2.contains((double)x - dx * factorX, (double)y3 - dy * factorY)) continue;
                        double xx = (double)x / factorX - dx;
                        double yy = (double)y3 / factorY - dy;
                        double z = Render3DTool.getDepth(xx, yy, d, nx, ny, nz, px, py, pz);
                        if (!(d3 < zBuffer[y3][x])) continue;
                        zBuffer[y3][x] = z;
                        markBuffer[y3][x] = polCounter;
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Warning: Line '" + line + "' seems to be invalid. - ignored");
            }
        }
        if (style == 0 || style == 2) {
            for (int y4 = 0; y4 < vHeight; ++y4) {
                for (int x = 0; x < vWidth; ++x) {
                    if (markBuffer[y4][x] <= 0) continue;
                    if (x + 1 < vWidth && markBuffer[y4][x + 1] != markBuffer[y4][x]) {
                        markPlate.set(x, y4);
                        continue;
                    }
                    if (y4 + 1 < vHeight && markBuffer[y4 + 1][x] != markBuffer[y4][x]) {
                        markPlate.set(x, y4);
                        continue;
                    }
                    if (x + 1 < vWidth && markBuffer[y4][x + 1] == 0) {
                        markPlate.set(x, y4);
                        continue;
                    }
                    if (y4 + 1 < vHeight && markBuffer[y4 + 1][x] == 0) {
                        markPlate.set(x, y4);
                        continue;
                    }
                    if (x > 0 && markBuffer[y4][x - 1] == 0) {
                        markPlate.set(x, y4);
                        continue;
                    }
                    if (y4 <= 0 || markBuffer[y4 - 1][x] != 0) continue;
                    markPlate.set(x, y4);
                }
            }
            return;
        }
        if (style == 4) {
            for (int y5 = 0; y5 < vHeight; ++y5) {
                for (int x = 0; x < vWidth; ++x) {
                    markPlate.set(x, y5, " 0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ#*+-:?!()[]{}@".charAt(markBuffer[y5][x]));
                }
            }
            return;
        }
        if (style == 3) {
            for (int y6 = 0; y6 < vHeight; ++y6) {
                for (int x = 0; x < vWidth; ++x) {
                    if (markBuffer[y6][x] <= 0) continue;
                    int shade = (Integer)shades.elementAt(markBuffer[y6][x] - 1);
                    markPlate.set(x, y6, gradient.charAt(gradient.length() - shade - 1));
                }
            }
            return;
        }
        double min = 0.0;
        double max = 0.0;
        for (y = 0; y < vHeight; ++y) {
            for (int x = 0; x < vWidth; ++x) {
                if (zBuffer[y][x] < min) {
                    min = zBuffer[y][x];
                }
                if (!(zBuffer[y][x] > max) || !(zBuffer[y][x] < Double.MAX_VALUE)) continue;
                max = zBuffer[y][x];
            }
        }
        for (y = 0; y < vHeight; ++y) {
            for (int x = 0; x < vWidth; ++x) {
                if (zBuffer[y][x] > max) continue;
                int index = (int)((zBuffer[y][x] - min) / (max - min) * (double)gradient.length());
                if (index < 0) {
                    index = 0;
                } else if (index >= gradient.length()) {
                    index = gradient.length() - 1;
                }
                markPlate.set(x, y, gradient.charAt(index));
            }
        }
    }

    public static final double getDepth(double x, double y, double d, double nx, double ny, double nz, double px, double py, double pz) {
        double sx = x - 0.0;
        double sy = y - 0.0;
        double sz = d;
        double a = (px * nx + py * ny + pz * nz) / (sx * nx + sy * ny + sz * nz);
        return a;
    }

    public static final double[] transform(double x, double y, double z, double alpha, double d, double scaleX, double scaleY, double dx, double dy) {
        double a = alpha / 180.0 * Math.PI;
        double x1 = x * Math.cos(a) + z * Math.sin(a);
        double y1 = y;
        double z1 = z * Math.cos(a) - x * Math.sin(a);
        double xR = x1;
        double yR = y1;
        double zR = z1;
        double xx = (x1 *= scaleX) / (z1 / d + 1.0);
        double yy = (y1 *= -scaleY) / (z1 / d + 1.0);
        return new double[]{xx, yy, z1, x1, y1, xR, yR, zR};
    }

    public final void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.chDemo) {
            this.taScript.setText(DEMOS_CONTENTS[this.chDemo.getSelectedIndex()]);
            this.render();
            return;
        }
        if (source == this.chStyle) {
            this.tfGradient.setEnabled(this.chStyle.getSelectedIndex() == 3);
            this.render();
            return;
        }
    }

    private void animate(Component parentComponent) {
        File file = FileChooserUtilities.performSaveFileChooser(parentComponent, new JmovFileChooserConfiguration(this.getCurrentDirectoryModel()));
        if (file == null) {
            return;
        }
        double dx = this.plateWidth / 2;
        double dy = this.plateHeight / 2;
        int style = this.chStyle.getSelectedIndex();
        String gradient = (String)this.tfGradient.getSelectedItem();
        if (gradient.length() == 0) {
            gradient = " ";
        }
        try {
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            bw.write("*:" + JaveTitleProvider.JAVE + " (" + "3D Rendering Tool" + ")");
            bw.newLine();
            bw.write("D:" + Toolbox.getDateString());
            bw.newLine();
            bw.write("C:#000000 #FFFFFF");
            bw.newLine();
            PixelPlate plate = new PixelPlate(0, 0, this.plateWidth, this.plateHeight);
            plate.setMode(PixelPlateMode.DOT);
            for (int angle = 0; angle < 360; angle += 3) {
                plate.clear();
                Render3DTool.render(plate, this.taScript.getText(), style, gradient, this.alpha + angle, 3.0, this.zoom, dx, dy);
                plate.convert();
                CharacterPlate cp = plate.getResult();
                cp.replace('\u0000', ' ');
                bw.write("J:");
                bw.write(JaveAsciiPacker.encode(cp));
                bw.newLine();
            }
            bw.close();
        }
        catch (Exception e) {
            System.err.println(e);
            e.printStackTrace(System.err);
            System.err.println("Error saving File: " + e);
            return;
        }
        this.getCurrentDirectoryModel().setFile(file.getParentFile());
    }
}

