/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave;

import de.jave.gui.GTextArea;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.Jave;
import de.jave.jave.ResultConverter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;
import net.disy.commons.swing.ui.IObjectUi;
import net.disy.commons.swing.ui.ObjectUiListCellRenderer;

public final class ResultDialog {
    private static final ResultConverter[] CONVERTERS = new ResultConverter[]{new ResultConverter("plain text", "", "", "", false), new ResultConverter("HTML", "<pre>", "", "</pre>", true), new ResultConverter("JavaDoc comment", "/**\n", "* ", "\n*/", true), new ResultConverter("Java comment", "/*\n", "", "\n*/", false), new ResultConverter("Shell comment", "", "# ", "", false), new ResultConverter("C++ comment", "", "// ", "", false), new ResultConverter("C comment", "/*\n", "", "\n*/", false), new ResultConverter("HTML comment", "<!--\n", "", "\n-->", false), new ResultConverter("Modula2 comment", "(*\n", "", "\n*)", false), new ResultConverter("TeX comment", "", "% ", "", false), new ResultConverter("TeX text", "\\begin{verbatim}", "", "\\end{verbatim}", false)};
    private GTextArea taText;
    private JComboBox chConverter;
    private int mode;
    private String original;
    private final JDialog dialog;

    public ResultDialog(Jave parent, String text, Font font) {
        this.dialog = GDialog.createJDialog(parent.getFrame(), "Result Output", false);
        this.original = text;
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                ResultDialog.this.dialog.dispose();
            }
        });
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.taText = new GTextArea(text, 24, 85);
        if (font != null) {
            this.taText.setFont(font);
        }
        this.taText.setEditable(false);
        this.dialog.getContentPane().add((Component)this.taText.getContent(), "Center");
        this.taText.selectAll();
        JPanel topPanel = new JPanel(new FlowLayout(0));
        topPanel.add(new JLabel("Format:"));
        this.chConverter = new JComboBox<ResultConverter>(CONVERTERS);
        this.chConverter.setRenderer(new ObjectUiListCellRenderer(new IObjectUi(this){

            public final Icon getIcon(Object value) {
                return null;
            }

            public final String getLabel(Object value) {
                return ((ResultConverter)value).getName();
            }
        }));
        this.chConverter.setSelectedIndex(0);
        this.mode = 0;
        this.chConverter.addItemListener(new ItemListener(){

            public final void itemStateChanged(ItemEvent e) {
                ResultDialog.this.setCommentMode(ResultDialog.this.chConverter.getSelectedIndex());
            }
        });
        topPanel.add(this.chConverter);
        topPanel.add(new JButton(new SmartAction("Trim"){

            protected final void execute(Component parentComponent) {
                ResultDialog.this.trim();
            }
        }));
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        SmartAction copyAction = new SmartAction("Copy to System Clipboard"){

            protected final void execute(Component parentComponent) {
                Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
                StringSelection sel = new StringSelection(ResultDialog.this.taText.getText());
                clipboard.setContents(sel, sel);
            }
        };
        buttonPanelBuilder.add(copyAction);
        buttonPanelBuilder.add(new SmartAction("&Close"){

            protected final void execute(Component parentComponent) {
                ResultDialog.this.dialog.dispose();
            }
        });
        this.dialog.getContentPane().add((Component)topPanel, "North");
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        this.dialog.pack();
        this.dialog.setVisible(true);
    }

    private void setCommentMode(int mode) {
        this.mode = mode;
        this.taText.setText(CONVERTERS[mode].convert(this.original));
        this.taText.selectAll();
    }

    private void trim() {
        this.taText.setText(this.original);
        this.taText.trim();
        this.taText.selectAll();
        this.original = this.taText.getText();
        this.setCommentMode(this.mode);
    }
}

