/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.actions;

import de.jave.gui.GButton;
import de.jave.gui.GButtonGroup;
import de.jave.gui.GCheckbox;
import de.jave.gui.layout.Gap;
import de.jave.jave.ArcToolGeneric;
import de.jave.jave.BezierToolGeneric;
import de.jave.jave.BrushTool;
import de.jave.jave.CloneTool;
import de.jave.jave.EllipseToolGeneric;
import de.jave.jave.EraserTool;
import de.jave.jave.FreehandSelectionTool;
import de.jave.jave.FreehandToolGeneric;
import de.jave.jave.Jave;
import de.jave.jave.JaveImages;
import de.jave.jave.LineToolGeneric;
import de.jave.jave.PanTool;
import de.jave.jave.RectangleToolGeneric;
import de.jave.jave.SelectionTool;
import de.jave.jave.Tool;
import de.jave.jave.WatermarkTool;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.figlet.FIGletTool;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.jave.tool.auxiliarylines.AuxiliaryLinesTool;
import de.jave.jave.tool.ellipsealgorithmic.EllipseAlgorithmicTool;
import de.jave.jave.tool.fill.FillTool;
import de.jave.jave.tool.freehandalgorrithmic.FreehandAlgorithmicTool;
import de.jave.jave.tool.linealgorithmic.LineAlgorithmicTool;
import de.jave.jave.tool.rectanglealgorithmic.RectangleAlgorithmicTool;
import de.jave.jave.tool.text.TextTool;
import de.jave.jave.watermark.IWatermarkPainter;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.disy.commons.swing.layout.grid.GridAlignment;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.widgets.HorizontalLine;

public final class ToolBar
implements ItemListener {
    private Jave jave;
    private GButtonGroup buttonGroup;
    private JCheckBox cbWatermark;
    private JCheckBox cbAuxLines;
    private Tool[] tools;
    private final JaveApplicationPreferences preferences;
    private JComponent content;

    public ToolBar(Jave jave, JaveApplicationPreferences preferences, PlatePreferences plateViewOptions) {
        int i;
        this.jave = jave;
        this.preferences = preferences;
        this.createTools();
        this.cbWatermark = new JCheckBox((String)null, false);
        this.cbWatermark.setToolTipText("Show / Hide Watermark");
        this.cbWatermark.addItemListener(this);
        this.cbAuxLines = new JCheckBox((String)null, false);
        this.cbAuxLines.setToolTipText("Show / Hide Auxiliary Lines");
        this.cbAuxLines.addItemListener(this);
        GCheckbox cbGrid = new GCheckbox(plateViewOptions.getGridVisibilityModel(), JaveImageProvider.getInstance().getImageIcon("grid.gif"));
        cbGrid.setToolTipText("Show / Hide Grid");
        GCheckbox cbPure = new GCheckbox(plateViewOptions.getMarkIllegalModel(), JaveImageProvider.getInstance().getImageIcon("pure_toggle.gif"));
        cbPure.setToolTipText("Mark Characters not belonging to the current character set");
        GCheckbox cbPixel = new GCheckbox(plateViewOptions.getConnectedLinesViewModel(), JaveImageProvider.getInstance().getImageIcon("pixel_toggle.gif"));
        cbPixel.setToolTipText("Toggle ASCII/Connected Lines View");
        GridDialogLayoutData twoColumnsData = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        twoColumnsData.setHorizontalSpan(2);
        GridDialogLayoutData labelData = new GridDialogLayoutData(GridDialogLayoutData.CENTER);
        labelData.setVerticalAlignment(GridAlignment.END);
        JLabel genericToolsLabel = new JLabel(JaveImageProvider.getInstance().getImageIcon("tool/tool_generic.gif"));
        genericToolsLabel.setToolTipText("<html><b>Generic Tools:</b><p>Generic tools use a complex computational algorithm for creating shapes.<br> Each tool uses the same generic algorithm.<br> Generic tools work best for freehand shapes, ellipses, Bezier curves and arcs.</p></html>");
        JLabel algorithmicToolsLabel = new JLabel(JaveImageProvider.getInstance().getImageIcon("tool/tool_algorithmic.gif"));
        algorithmicToolsLabel.setToolTipText("<html><b>Algorithmic Tools:</b><p>Algorithmic tools use algorithms from Ascii Artists.<br> Each shape has an algorithm or a set of algorithms of its own.<br> Algorithmic tools work best for lines and rectangles.</p></html>");
        JPanel panel = new JPanel(new GridDialogLayout(2, true, 0, 0));
        panel.add((Component)new Gap(1, 6), twoColumnsData);
        panel.add((Component)genericToolsLabel, labelData);
        panel.add((Component)algorithmicToolsLabel, labelData);
        panel.add((Component)new Gap(1, 3), twoColumnsData);
        for (i = 0; i < 10; ++i) {
            if (i == 9) {
                panel.add(new Gap());
            }
            panel.add(this.buttonGroup.getButton(i));
        }
        panel.add(new Gap());
        panel.add((Component)this.createHorizontalLine(6), twoColumnsData);
        for (i = 10; i < 14; ++i) {
            panel.add(this.buttonGroup.getButton(i));
        }
        panel.add((Component)this.createHorizontalLine(6), twoColumnsData);
        for (i = 14; i < 19; ++i) {
            panel.add(this.buttonGroup.getButton(i));
        }
        panel.add(new Gap());
        panel.add((Component)this.createHorizontalLine(6), twoColumnsData);
        panel.add(this.cbWatermark);
        panel.add(this.buttonGroup.getButton(19));
        panel.add(this.cbAuxLines);
        panel.add(this.buttonGroup.getButton(20));
        panel.add((Component)new Gap(3, 3), twoColumnsData);
        panel.add((Component)this.createHorizontalLine(1), twoColumnsData);
        panel.add((Component)this.createHorizontalLine(1), twoColumnsData);
        panel.add((Component)cbGrid.getContent(), twoColumnsData);
        panel.add((Component)cbPure.getContent(), twoColumnsData);
        panel.add((Component)cbPixel.getContent(), twoColumnsData);
        panel.add((Component)this.createHorizontalLine(2), twoColumnsData);
        this.content = panel;
    }

    private HorizontalLine createHorizontalLine(int verticalSpace) {
        HorizontalLine horizontalLine = new HorizontalLine(20);
        horizontalLine.setMargin(new Insets(LayoutUtilities.getDpiAdjusted(verticalSpace), LayoutUtilities.getDpiAdjusted(3), LayoutUtilities.getDpiAdjusted(verticalSpace), LayoutUtilities.getDpiAdjusted(3)));
        return horizontalLine;
    }

    public final void itemStateChanged(ItemEvent evt) {
        Object source = evt.getSource();
        if (source == this.buttonGroup) {
            this.jave.setTool(this.buttonGroup.getSelectedIndex());
        } else if (source == this.cbWatermark) {
            ((IWatermarkPainter)((Object)this.tools[19])).setEnabled(this.cbWatermark.isSelected());
            this.jave.getMainPanel().getPlate().repaint();
        }
        if (source == this.cbAuxLines) {
            ((IWatermarkPainter)((Object)this.tools[20])).setEnabled(this.cbAuxLines.isSelected());
            this.jave.getMainPanel().getPlate().repaint();
        }
        this.jave.getMainPanel().requestFocus();
    }

    public final void setWatermarkVisible(boolean what) {
        ((IWatermarkPainter)((Object)this.tools[19])).setEnabled(what);
        this.cbWatermark.setSelected(what);
    }

    public final void setAuxiliaryLinesVisible(boolean what) {
        ((IWatermarkPainter)((Object)this.tools[20])).setEnabled(what);
        this.cbAuxLines.setSelected(what);
    }

    public final void selectToolButton(int index) {
        this.buttonGroup.selectButton(index);
    }

    protected final void createTools() {
        JaveMainPanel mainPanel = this.jave.getMainPanel();
        this.tools = new Tool[21];
        this.tools[0] = new FreehandToolGeneric(mainPanel, this.jave);
        this.tools[2] = new LineToolGeneric(mainPanel, this.jave);
        this.tools[4] = new RectangleToolGeneric(mainPanel, this.jave);
        this.tools[6] = new EllipseToolGeneric(mainPanel, this.jave);
        this.tools[8] = new BezierToolGeneric(mainPanel, this.jave);
        this.tools[9] = new ArcToolGeneric(mainPanel, this.jave);
        this.tools[1] = new FreehandAlgorithmicTool(mainPanel, this.jave);
        this.tools[3] = new LineAlgorithmicTool(mainPanel, this.jave);
        this.tools[5] = new RectangleAlgorithmicTool(mainPanel, this.jave);
        this.tools[7] = new EllipseAlgorithmicTool(mainPanel, this.jave);
        this.tools[10] = new TextTool(mainPanel, this.jave, this.preferences.getCursorBlockStyleModel());
        this.tools[11] = new FIGletTool(mainPanel, this.jave);
        this.tools[12] = new SelectionTool(mainPanel, this.jave);
        this.tools[13] = new FreehandSelectionTool(mainPanel, this.jave);
        this.tools[14] = new BrushTool(mainPanel, this.jave);
        this.tools[15] = new EraserTool(mainPanel, this.jave);
        this.tools[16] = new FillTool(mainPanel, this.jave);
        this.tools[17] = new CloneTool(mainPanel, this.jave);
        this.tools[18] = new PanTool(mainPanel, this.jave);
        this.tools[19] = new WatermarkTool(mainPanel, this.jave);
        this.tools[20] = new AuxiliaryLinesTool(mainPanel, this.jave);
        mainPanel.getToolManager().setTools(this.tools);
        mainPanel.setCurrentTool(this.tools[0]);
        this.buttonGroup = new GButtonGroup();
        for (int j = 0; j < 21; ++j) {
            GButton b = JaveImages.createButton(this.tools[j].getIcon());
            b.set3DMode(1);
            this.buttonGroup.add(b);
            b.setToolTipText(this.tools[j].getName());
        }
        this.buttonGroup.addItemListener(this);
    }

    public final JComponent getContent() {
        return this.content;
    }
}

