/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.image2ascii.AsciiGreyscaleTable;
import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.BrightnessOptions;
import de.jave.jave.algorithm.JaveAlgorithmOptions;
import de.jave.jave.algorithm.JaveOptionsAlgorithm;
import de.jave.lib.BooleanPlate;
import de.jave.lib.CharacterPlate;
import java.util.Random;

public final class Brightness
extends JaveOptionsAlgorithm {
    private static Brightness instance;
    protected BrightnessOptions options;

    private Brightness() {
    }

    public static final synchronized Brightness getInstance() {
        if (instance == null) {
            instance = new Brightness();
        }
        return instance;
    }

    public final JaveAlgorithmOptions getOptions() {
        if (this.options == null) {
            this.options = new BrightnessOptions();
        }
        return this.options;
    }

    public final String getActionName() {
        return "brightness";
    }

    public final String getMenuItemLabel() {
        return "Brightness...";
    }

    public final JaveSelection apply(JaveSelection sel) {
        double brighten = this.options.getFactor();
        int algorithm = this.options.getAlgorithm();
        AsciiGreyscaleTable greyscaleTable = this.options.getGreyscaleTable();
        char fillChar = this.options.getChar();
        if (brighten == 0.0 || greyscaleTable == null) {
            return sel;
        }
        int width = sel.getWidth();
        int height = sel.getHeight();
        CharacterPlate sourcePlate = sel.getContent();
        BooleanPlate sourceMask = sel.getMask();
        CharacterPlate result = new CharacterPlate(width, height);
        switch (algorithm) {
            case 0: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (sourceMask != null && !sourceMask.isSet(x, y)) continue;
                        char ch = sourcePlate.get(x, y);
                        int brightness = greyscaleTable.getBrightnessForChar(ch);
                        result.set(x, y, greyscaleTable.getCharForBrightness(brightness += (int)(brighten * 255.0)));
                    }
                }
                break;
            }
            case 1: {
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (sourceMask != null && !sourceMask.isSet(x, y)) continue;
                        char ch = sourcePlate.get(x, y);
                        char[] brightness = greyscaleTable.getBrightness4ForChar(ch);
                        for (int i = 0; i < 4; ++i) {
                            int newBrightness = brightness[i] + (int)(brighten * 255.0);
                            if (newBrightness > 255) {
                                newBrightness = 255;
                            } else if (newBrightness < 0) {
                                newBrightness = 0;
                            }
                            brightness[i] = (char)newBrightness;
                        }
                        result.set(x, y, greyscaleTable.getCharForBrightness(brightness));
                    }
                }
                break;
            }
            case 2: {
                Random r = new Random(width * height);
                for (int y = 0; y < height; ++y) {
                    for (int x = 0; x < width; ++x) {
                        if (sourceMask != null && !sourceMask.isSet(x, y)) continue;
                        double random = r.nextDouble();
                        if (brighten > 0.0 && random > brighten) {
                            result.set(x, y, sourcePlate.get(x, y));
                            continue;
                        }
                        if (!(brighten < 0.0)) continue;
                        if (random > -brighten) {
                            result.set(x, y, sourcePlate.get(x, y));
                            continue;
                        }
                        result.set(x, y, fillChar);
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("No such algorithm id in Brightness!");
            }
        }
        sel.setContent(result);
        sel.setMask(sourceMask);
        return sel;
    }
}

