/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.CompressExpandOptions;
import de.jave.jave.algorithm.JaveAlgorithmOptions;
import de.jave.jave.algorithm.JaveOptionsAlgorithm;
import de.jave.lib.BooleanPlate;
import de.jave.lib.CharacterPlate;

public final class CompressExpand
extends JaveOptionsAlgorithm {
    private static CompressExpand instance;
    protected CompressExpandOptions options;

    private CompressExpand() {
    }

    public static final synchronized CompressExpand getInstance() {
        if (instance == null) {
            instance = new CompressExpand();
        }
        return instance;
    }

    public final JaveAlgorithmOptions getOptions() {
        if (this.options == null) {
            this.options = new CompressExpandOptions();
        }
        return this.options;
    }

    public final String getActionName() {
        return "compress/expand";
    }

    public final String getMenuItemLabel() {
        return "Compress/Expand...";
    }

    public final JaveSelection apply(JaveSelection sel) {
        int sourceWidth = sel.getWidth();
        int sourceHeight = sel.getHeight();
        int newWidth = this.options.getNewWidth();
        int newHeight = this.options.getNewHeight();
        double xScale = (double)newWidth / (double)sourceWidth;
        double yScale = (double)newHeight / (double)sourceHeight;
        CharacterPlate sourcePlate = sel.getContent();
        CharacterPlate resultContent = new CharacterPlate(newWidth, newHeight);
        BooleanPlate sourceMask = sel.getMask();
        BooleanPlate resultMask = new BooleanPlate(newWidth, newHeight);
        resultContent.setMix(true);
        if (xScale <= 1.0 && yScale <= 1.0) {
            for (int y = 0; y < sourceHeight; ++y) {
                for (int x = 0; x < sourceWidth; ++x) {
                    int xx = (int)Math.round((double)x * xScale);
                    int yy = (int)Math.round((double)y * yScale);
                    char ch = sourcePlate.get(x, y);
                    if (ch != ' ') {
                        resultContent.set(xx, yy, ch);
                    }
                    if (sourceMask != null && !sourceMask.isSet(x, y)) continue;
                    resultMask.set(xx, yy, true);
                }
            }
        } else if (xScale <= 1.0 && yScale > 1.0) {
            for (int yy = 0; yy < newHeight; ++yy) {
                for (int x = 0; x < sourceWidth; ++x) {
                    int y = (int)((double)yy / yScale);
                    int xx = (int)Math.round((double)x * xScale);
                    char ch = sourcePlate.get(x, y);
                    if (ch != ' ') {
                        resultContent.set(xx, yy, ch);
                    }
                    if (sourceMask != null && !sourceMask.isSet(x, y)) continue;
                    resultMask.set(xx, yy, true);
                }
            }
        } else if (xScale > 1.0 && yScale <= 1.0) {
            for (int y = 0; y < sourceHeight; ++y) {
                for (int xx = 0; xx < newWidth; ++xx) {
                    int yy = (int)Math.round((double)y * yScale);
                    int x = (int)((double)xx / xScale);
                    char ch = sourcePlate.get(x, y);
                    if (ch != ' ') {
                        resultContent.set(xx, yy, ch);
                    }
                    if (sourceMask != null && !sourceMask.isSet(x, y)) continue;
                    resultMask.set(xx, yy, true);
                }
            }
        } else {
            for (int yy = 0; yy < newHeight; ++yy) {
                for (int xx = 0; xx < newWidth; ++xx) {
                    int x = (int)((double)xx / xScale);
                    int y = (int)((double)yy / yScale);
                    char ch = sourcePlate.get(x, y);
                    if (ch != ' ') {
                        resultContent.set(xx, yy, ch);
                    }
                    if (sourceMask != null && !sourceMask.isSet(x, y)) continue;
                    resultMask.set(xx, yy, true);
                }
            }
        }
        sel.setContent(resultContent);
        sel.setMask(resultMask);
        return sel;
    }
}

