/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.jave.JaveSelection;
import de.jave.jave.algorithm.JaveAlgorithm;
import de.jave.lib.BooleanPlate;

public final class MirrorStatic
extends JaveAlgorithm {
    private static MirrorStatic instance;

    private MirrorStatic() {
    }

    public static final synchronized MirrorStatic getInstance() {
        if (instance == null) {
            instance = new MirrorStatic();
        }
        return instance;
    }

    public final String getActionName() {
        return "mirror static";
    }

    public final String getMenuItemLabel() {
        return "Mirror static";
    }

    public final JaveSelection apply(JaveSelection plate) {
        int h = plate.getHeight();
        int w = plate.getWidth();
        char[][] ch = plate.getContent().getContent();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w / 2; ++x) {
                char t = ch[y][x];
                ch[y][x] = ch[y][w - x - 1];
                ch[y][w - x - 1] = t;
            }
        }
        BooleanPlate mask = plate.getMask();
        if (mask != null) {
            boolean[][] m = mask.getContent();
            for (int y = 0; y < h; ++y) {
                for (int x = 0; x < w / 2; ++x) {
                    boolean t = m[y][x];
                    m[y][x] = m[y][w - x - 1];
                    m[y][w - x - 1] = t;
                }
            }
        }
        return plate;
    }
}

