/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm;

import de.jave.image.Rotation;
import de.jave.image2ascii.RotationUi;
import de.jave.jave.JaveSelection;
import de.jave.jave.actions.AbstractJaveUndoableAction;
import de.jave.jave.actions.enablestrategy.IJaveDocumentEditorActionEnabledStrategy;
import de.jave.jave.actions.enablestrategy.TextAndAnimationEditorEnabledStrategy;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.algorithm.Rotate90RightStaticAction;
import de.jave.jave.plate.JaveMainPanel;
import java.awt.Component;
import java.awt.Dimension;

public final class Rotate90RightAction
extends AbstractJaveUndoableAction {
    public Rotate90RightAction(JaveMainPanel mainPanel) {
        super(mainPanel, "90 degrees right", new RotationUi().getIcon(Rotation.RIGHT));
    }

    protected final String getActionName() {
        return "rotate 90 degrees";
    }

    protected final JaveSelection apply(Component parentComponent, JaveSelection selection) {
        selection = Rotate90RightStaticAction.applyTo(selection);
        char[][] ch = selection.getContent().getContent();
        char[] table = GeneralAlgorithm.getRotate90Right().toCharArray();
        Dimension size = selection.getSize();
        for (int y = 0; y < size.height; ++y) {
            for (int x = 0; x < size.width; ++x) {
                if (ch[y][x] < ' ' || ch[y][x] > '~') continue;
                ch[y][x] = table[ch[y][x] - 32];
            }
        }
        return selection;
    }

    protected final IJaveDocumentEditorActionEnabledStrategy getEnabledStrategy() {
        return TextAndAnimationEditorEnabledStrategy.getInstance();
    }
}

