/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.camel;

import de.jave.image.GImage;
import de.jave.image.greyscale.GGreyscaleImage;
import de.jave.image.greyscale.GreyscaleImageFactory;
import de.jave.image.monochrome.GMonochromeImage;
import de.jave.jave.algorithm.GeneralAlgorithm;
import de.jave.jave.algorithm.camel.CamelMode;
import de.jave.lib.CharacterPlate;
import java.awt.Component;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.PixelGrabber;
import java.util.StringTokenizer;
import java.util.Vector;

public final class Camel {
    private String[] textWords;
    private String textPure;
    private String textPreserveSpaces;
    private GGreyscaleImage imageRawInternal;
    private GImage imagePreview;
    private static int difference;

    public Camel(String text) {
        this.setSourceText(text);
    }

    public final void setRawImage(GGreyscaleImage image) {
        if (image.getWidth() > 180) {
            this.imageRawInternal = image.getYScaledInstance(0.5);
            return;
        }
        this.imageRawInternal = image.getXScaledInstance(2.0);
    }

    public final GImage getPreviewImage() {
        return this.imagePreview;
    }

    public final boolean checkReady() {
        return this.imageRawInternal != null;
    }

    public final CharacterPlate camelize(CamelMode mode, boolean negative, double brightness, char fillChar) {
        CharacterPlate cp = null;
        int charCount = 0;
        GMonochromeImage imageShape = null;
        if (mode == CamelMode.RAW_TEXT) {
            charCount = this.textPure.length();
            imageShape = Camel.getShapeImage(this.imageRawInternal, brightness, charCount, negative);
            cp = Camel.textToShape(this.textPure, imageShape);
            this.imagePreview = imageShape.scaleY2();
        } else if (mode == CamelMode.PRESERVE_SPACES) {
            charCount = this.textPreserveSpaces.length();
            imageShape = Camel.getShapeImage(this.imageRawInternal, brightness, charCount, negative);
            cp = Camel.textToShape(this.textPreserveSpaces, imageShape);
            this.imagePreview = imageShape.scaleY2();
        } else if (mode == CamelMode.PRESERVE_WORDS) {
            charCount = this.textPure.length();
            do {
                imageShape = Camel.getShapeImage(this.imageRawInternal, brightness, charCount, negative);
                cp = Camel.wordsToShape(this.textWords, imageShape, fillChar);
                charCount *= 2;
            } while (difference < 0);
            boolean done = false;
            int step = (charCount /= 2) / 4;
            charCount /= 2;
            while (!done) {
                imageShape = Camel.getShapeImage(this.imageRawInternal, brightness, charCount, negative);
                cp = Camel.wordsToShape(this.textWords, imageShape, fillChar);
                if (difference == 0 || step == 0) {
                    done = true;
                } else {
                    charCount = difference > 0 ? (charCount -= step) : (charCount += step);
                }
                step /= 2;
            }
            if (difference < 0) {
                imageShape = Camel.getShapeImage(this.imageRawInternal, brightness, ++charCount, negative);
                cp = Camel.wordsToShape(this.textWords, imageShape, fillChar);
            }
            this.imagePreview = imageShape.scaleY2();
        } else {
            throw new UnsupportedOperationException(mode + " not supported.");
        }
        return cp;
    }

    private static CharacterPlate textToShape(String sourceText, GMonochromeImage shapeImage) {
        int charCount = sourceText.length();
        int w = shapeImage.getWidth();
        int h = shapeImage.getHeight();
        CharacterPlate result = new CharacterPlate(w, h);
        int i = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                if (shapeImage.get(x, y) != 0 || i >= charCount) continue;
                result.set(x, y, sourceText.charAt(i++));
            }
        }
        GeneralAlgorithm.replace(result, '\u00a0', ' ');
        return result;
    }

    private static CharacterPlate wordsToShape(String[] words, GMonochromeImage shapeImage, char fillChar) {
        int i;
        boolean fill = false;
        int w = shapeImage.getWidth();
        int h = shapeImage.getHeight();
        int wordCount = words.length;
        Vector<CamelRun> runs = new Vector<CamelRun>();
        CamelRun run = Camel.getNextRun(0, 0, w, h, shapeImage);
        while (run != null) {
            runs.addElement(run);
            run = Camel.getNextRun(run.xEnd + 1, run.y, w, h, shapeImage);
        }
        difference = 0;
        int wordIndex = 0;
        for (i = 0; i < runs.size(); ++i) {
            run = (CamelRun)runs.elementAt(i);
            if (wordIndex >= wordCount) {
                difference += run.length;
                continue;
            }
            int l = run.length;
            if (words[wordIndex].length() > l) continue;
            run.text = words[wordIndex];
            l -= words[wordIndex].length();
            ++wordIndex;
            while (wordIndex < wordCount && words[wordIndex].length() + 1 <= l) {
                run.text = run.text + fillChar + words[wordIndex];
                l -= words[wordIndex].length() + 1;
                ++wordIndex;
            }
        }
        for (i = wordIndex; i < wordCount; ++i) {
            difference -= words[i].length();
        }
        CharacterPlate cp = new CharacterPlate(w, h);
        for (int i2 = 0; i2 < runs.size(); ++i2) {
            run = (CamelRun)runs.elementAt(i2);
            if (run.text != null) {
                cp.paste(Camel.stretch(run.text, run.length, fillChar), run.xStart, run.y);
                continue;
            }
            for (int j = run.xStart; j <= run.xEnd; ++j) {
                cp.setForce(j, run.y, fillChar);
            }
        }
        return cp;
    }

    private static final String stretch(String text, int length, char fillChar) {
        int diff = length - text.length();
        if (diff == 0) {
            return text;
        }
        int i1 = text.indexOf(fillChar);
        if (i1 == -1) {
            return Camel.spaces(diff / 2, fillChar) + text + Camel.spaces(diff - diff / 2, fillChar);
        }
        while (diff > 0) {
            text = text.substring(0, i1) + fillChar + text.substring(i1);
            --diff;
            if ((i1 = text.indexOf(fillChar, i1 + 2)) != -1) continue;
            i1 = text.indexOf(fillChar);
        }
        return text;
    }

    private static final String spaces(int length, char fillChar) {
        char[] ch = new char[length];
        for (int i = 0; i < length; ++i) {
            ch[i] = fillChar;
        }
        return new String(ch);
    }

    private static CamelRun getNextRun(int x, int y, int w, int h, GMonochromeImage shapeImage) {
        if (x >= w) {
            return Camel.getNextRun(0, y + 1, w, h, shapeImage);
        }
        if (y >= h) {
            return null;
        }
        while (x < w && shapeImage.get(x, y) != 0) {
            ++x;
        }
        if (x == w) {
            return Camel.getNextRun(0, y + 1, w, h, shapeImage);
        }
        CamelRun run = new CamelRun();
        new CamelRun().xStart = x;
        run.y = y;
        while (x + 1 < w && shapeImage.get(x + 1, y) == 0) {
            ++x;
        }
        run.xEnd = x;
        run.length = run.xEnd - run.xStart + 1;
        return run;
    }

    public final void setSourceText(String text) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ' || ch == '\n') continue;
            sb.append(ch);
        }
        this.textPure = sb.toString();
        sb.setLength(0);
        boolean lastCharSpace = false;
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == ' ') {
                if (!lastCharSpace) {
                    sb.append('\u00a0');
                }
                lastCharSpace = true;
                continue;
            }
            if (ch == '\n') {
                if (!lastCharSpace) {
                    sb.append('\u00a0');
                }
                lastCharSpace = true;
                continue;
            }
            sb.append(ch);
            lastCharSpace = false;
        }
        this.textPreserveSpaces = sb.toString();
        StringTokenizer st = new StringTokenizer(this.textPreserveSpaces, String.valueOf('\u00a0'), false);
        int count = st.countTokens();
        this.textWords = new String[count];
        for (int i = 0; i < count; ++i) {
            this.textWords[i] = st.nextToken();
        }
    }

    public static final GGreyscaleImage loadImage(Image imageRaw, Component comp) {
        int imageWidth = imageRaw.getWidth(comp);
        int imageHeight = imageRaw.getHeight(comp);
        if (imageHeight > 300 || imageWidth > 400) {
            int newWidth = 0;
            int newHeight = 0;
            if (imageHeight > 300) {
                newHeight = 300;
                newWidth = 300 * imageWidth / imageHeight;
            } else {
                newWidth = 400;
                newHeight = 400 * imageHeight / imageWidth;
            }
            imageWidth = newWidth;
            imageHeight = newHeight;
            imageRaw = imageRaw.getScaledInstance(newWidth, newHeight, 2);
            MediaTracker tracker = new MediaTracker(comp);
            tracker.addImage(imageRaw, 0);
            try {
                tracker.waitForID(0);
            }
            catch (InterruptedException interruptedException) {}
        }
        int[] pixels = new int[imageWidth * imageHeight];
        PixelGrabber pg = new PixelGrabber(imageRaw, 0, 0, imageWidth, imageHeight, pixels, 0, imageWidth);
        try {
            pg.grabPixels();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Internal Error: " + e.toString());
        }
        return new GreyscaleImageFactory().createGreyscaleImage(pixels, imageWidth, imageHeight);
    }

    private static GMonochromeImage getShapeImage(GGreyscaleImage imageRaw, double brightness, int charCount, boolean negative) {
        if (negative) {
            imageRaw = (GGreyscaleImage)imageRaw.getClone();
            imageRaw.invert();
        }
        int w = imageRaw.getWidth();
        int h = imageRaw.getHeight();
        int startThreshold = 128 - (int)(96.0 * brightness);
        int startWidth = (int)Math.ceil((double)w * Math.sqrt((double)charCount / (double)imageRaw.countPixelsWithMaxValue(startThreshold)));
        int startHeight = h * startWidth / w;
        GGreyscaleImage g3 = null;
        g3 = imageRaw.getScaledInstance(startWidth, startHeight);
        int count = g3.countPixelsWithMaxValue(startThreshold);
        while (count < charCount) {
            startHeight = h * ++startWidth / w;
            g3 = imageRaw.getScaledInstance(startWidth, startHeight);
            count = g3.countPixelsWithMaxValue(startThreshold);
        }
        if (count > charCount) {
            int step = 64;
            boolean done = false;
            while (!done) {
                if (count == charCount || step == 0) {
                    done = true;
                    continue;
                }
                if (count < charCount) {
                    count = g3.countPixelsWithMaxValue(startThreshold += step);
                    step /= 2;
                    continue;
                }
                if (count <= charCount) continue;
                count = g3.countPixelsWithMaxValue(startThreshold -= step);
                step /= 2;
            }
            if (count < charCount) {
                ++startThreshold;
            }
        }
        return g3.threshold(startThreshold);
    }

    static final class CamelRun {
        int xStart;
        int y;
        int xEnd;
        int length;
        String text;

        CamelRun() {
        }

        public final String toString() {
            return "[" + this.xStart + ".." + this.xEnd + ";" + this.y + "]=" + this.length + "<" + this.text + ">";
        }
    }
}

