/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.algorithm.repair;

import de.jave.jave.algorithm.repair.AsciiRepairAlgorithmConfiguration;
import de.jave.jave.algorithm.repair.AsciiRepairRule;
import de.jave.lib.CharacterPlate;
import de.jave.lib.Toolbox;

public final class AsciiRepairAlgorithm {
    public static final CharacterPlate repairShaked(CharacterPlate cp) {
        int y;
        int h = cp.getHeight();
        int maxLength = 0;
        String[] lines = new String[h];
        for (y = 0; y < h; ++y) {
            lines[y] = cp.getLine(y).trim();
            if (lines[y].length() <= maxLength) continue;
            maxLength = lines[y].length();
        }
        if (maxLength == 0) {
            return null;
        }
        for (y = 0; y < h - 1; ++y) {
            String a = lines[y];
            String b = lines[y + 1];
            if (b.length() == 0) continue;
            int maxV = 0;
            int maxRating = 0;
            for (int v = -b.length(); v <= a.length(); ++v) {
                int rating = AsciiRepairAlgorithm.rate(a, b, v);
                if (rating <= maxRating) continue;
                maxRating = rating;
                maxV = v;
            }
            if (maxV < 0) {
                String s = "";
                while (maxV < 0) {
                    s = s + " ";
                    ++maxV;
                }
                for (int i = 0; i <= y; ++i) {
                    lines[i] = s + lines[i];
                }
                continue;
            }
            if (maxV <= 0) continue;
            while (maxV > 0) {
                lines[y + 1] = " " + lines[y + 1];
                --maxV;
            }
        }
        return new CharacterPlate(lines);
    }

    public static final int rate(String a, String b, int v) {
        int length = 0;
        length = v > 0 ? Toolbox.max(a.length(), b.length() + v) : Toolbox.max(a.length(), b.length() + v) - v;
        char[] ch1 = new char[length];
        char[] ch2 = new char[length];
        for (int x = 0; x < length; ++x) {
            ch1[x] = 32;
            ch2[x] = 32;
        }
        char[] chA = a.toCharArray();
        char[] chB = b.toCharArray();
        if (v < 0) {
            System.arraycopy(chA, 0, ch1, -v, chA.length);
            System.arraycopy(chB, 0, ch2, 0, chB.length);
        } else {
            System.arraycopy(chA, 0, ch1, 0, chA.length);
            System.arraycopy(chB, 0, ch2, v, chB.length);
        }
        return AsciiRepairAlgorithm.rate(ch1, ch2);
    }

    private static int rate(char[] a, char[] b) {
        int x;
        AsciiRepairAlgorithmConfiguration configuration = AsciiRepairAlgorithmConfiguration.getInstance();
        int identical = configuration.getIdentical();
        int identicalLeft = configuration.getIdenticalLeft();
        int identicalRight = configuration.getIdenticalRight();
        AsciiRepairRule[] rules = configuration.getRules();
        int result = 0;
        for (x = 0; x < a.length; ++x) {
            if (a[x] == ' ' || a[x] != b[x]) continue;
            result += identical;
        }
        for (x = 1; x < a.length; ++x) {
            if (a[x] == ' ' || a[x] != b[x - 1]) continue;
            result += identicalLeft;
        }
        for (x = 0; x < a.length - 1; ++x) {
            if (a[x] == ' ' || a[x] != b[x + 1]) continue;
            result += identicalRight;
        }
        for (int i = 0; i < rules.length; ++i) {
            result += rules[i].rate(a, b);
        }
        return result;
    }
}

