/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.application.about;

import de.jave.gui.GHyperlink;
import de.jave.gui.layout.CenterLayout;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.application.startup.JaveSplashComponentFactory;
import de.jave.jave.version.JaveTitleProvider;
import de.jave.jave.version.JaveVersion;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.swing.dialog.BasicDialogUi;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogConfiguration;
import net.disy.commons.swing.dialog.userdialog.AbstractDialogPage;
import net.disy.commons.swing.dialog.userdialog.UserDialog;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.LayoutUtilities;
import net.disy.commons.swing.widgets.AutoWrappingLabel;
import net.disy.commons.swing.widgets.HorizontalLine;

public final class JaveAboutDialog {
    public static final void showAboutDialog(Component parentComponent) {
        UserDialog dialog = new UserDialog(parentComponent, new AbstractDialogConfiguration(new AbstractDialogPage(new BasicMessage()){

            public final String getTitle() {
                return "JavE " + JaveVersion.getFullVersionNumber();
            }

            public final IBasicMessage createCurrentMessage() {
                return this.getDefaultMessage();
            }

            public final JComponent createContent() {
                JTabbedPane tabbedPane = new JTabbedPane();
                tabbedPane.addTab("Splash Screen", JaveSplashComponentFactory.createSplashLogoComponent());
                tabbedPane.addTab("Details", JaveAboutDialog.createDetailsPanel());
                JPanel content = new JPanel();
                content.setLayout(new BorderLayout(LayoutUtilities.getComponentSpacing(), LayoutUtilities.getComponentGroupsSpacing()));
                content.add((Component)JaveAboutDialog.createTitle(), "North");
                content.add((Component)tabbedPane, "Center");
                return content;
            }
        }){

            public final boolean isCancelAvailable() {
                return false;
            }

            public final boolean isHeaderPanelVisible() {
                return false;
            }

            public final String getOkButtonText() {
                return BasicDialogUi.CLOSE_TEXT_SMART;
            }
        });
        dialog.show();
    }

    private static JComponent createTitle() {
        JLabel title = new JLabel(JaveTitleProvider.TITLE, 0);
        title.setFont(JaveGlobalRessources.FONT_BOLD);
        return title;
    }

    private static JComponent createDetailsPanel() {
        JPanel panel = new JPanel(new GridDialogLayout(2, false));
        panel.add((Component)new JLabel("JavE Homepage:"), GridDialogLayoutData.RIGHT);
        panel.add(new GHyperlink("http://www.jave.de", 0));
        panel.add((Component)new JLabel("Version:"), GridDialogLayoutData.RIGHT);
        panel.add(JaveAboutDialog.createSelectableLabel(JaveVersion.getFullVersionNumber() + " " + JaveVersion.getBuildDate()));
        panel.add((Component)new JLabel("Author:"), GridDialogLayoutData.RIGHT);
        panel.add(JaveAboutDialog.createSelectableLabel("Markus Gebhard"));
        panel.add((Component)new JLabel("Author E-mail:"), GridDialogLayoutData.RIGHT);
        panel.add(new GHyperlink("mailto:markus@jave.de?subject=jave", "markus@jave.de", 0));
        GridDialogLayoutData twoColumnsLayoutData = new GridDialogLayoutData(GridDialogLayoutData.FILL_HORIZONTAL);
        twoColumnsLayoutData.setHorizontalSpan(2);
        panel.add((Component)new HorizontalLine(), twoColumnsLayoutData);
        panel.add((Component)new JLabel("Operating System:"), GridDialogLayoutData.RIGHT);
        panel.add(JaveAboutDialog.createSelectableLabel(JaveAboutDialog.getOptionalSystemProperty("os.name")));
        panel.add((Component)new JLabel("Java Vendor:"), GridDialogLayoutData.RIGHT);
        panel.add(JaveAboutDialog.createSelectableLabel(JaveAboutDialog.getOptionalSystemProperty("java.vendor")));
        panel.add((Component)new JLabel("Java Version:"), GridDialogLayoutData.RIGHT);
        panel.add(JaveAboutDialog.createSelectableLabel(JaveAboutDialog.getOptionalSystemProperty("java.version")));
        panel.add((Component)new JLabel("Codebase:"), GridDialogLayoutData.RIGHT);
        panel.add(JaveAboutDialog.createSelectableLabel(JaveGlobalRessources.codeBase.getAbsolutePath()));
        JPanel detailsPanel = new JPanel(new CenterLayout());
        detailsPanel.add(panel);
        return detailsPanel;
    }

    private static String getOptionalSystemProperty(String propertyName) {
        try {
            String value = System.getProperty(propertyName);
            if (value == null) {
                return "n/a";
            }
            return value;
        }
        catch (Exception exception) {
            return "n/a";
        }
    }

    private static JComponent createSelectableLabel(String text) {
        return new AutoWrappingLabel(text, 150).getContent();
    }
}

