/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.application.startup;

import de.jave.gui.splash.IStartupMonitor;
import de.jave.gui.splash.StartupException;
import de.jave.image2ascii.AsciiGreyscaleTableConfiguration;
import de.jave.jave.CharSetsConfiguration;
import de.jave.jave.Filter;
import de.jave.jave.Jave;
import de.jave.jave.JaveConfigurationFileLoader;
import de.jave.jave.algorithm.GeneralAlgorithmConfiguration;
import de.jave.jave.algorithm.gradient.AsciiGradientConfiguration;
import de.jave.jave.algorithm.repair.AsciiRepairAlgorithmConfiguration;
import de.jave.jave.algorithm.replaceillegal.AsciiReplaceIllegalConfiguration;
import de.jave.jave.figlet.FigletConfiguration;
import de.jave.jave.pixelplate.PixelPlateConfiguration;
import de.jave.lib.CharacterPlateConfiguration;
import java.awt.Component;

public final class JaveStartupRunnable {
    public JaveStartupRunnable(String[] arguments) {
    }

    public final void startUp(IStartupMonitor monitor) throws StartupException {
        Jave jave = null;
        try {
            monitor.beginTask("Starting JavE...", -1);
            monitor.subTask("Creating User Interface...");
            jave = new Jave();
            monitor.subTask("Loading Configuration Files...");
            JaveStartupRunnable.initConfigFiles(monitor.getSplashWindow());
            monitor.subTask("Halfway Finished...");
            Filter.init();
            jave.setTool(0);
            monitor.subTask("Crash Recovery...");
            jave.startupRecovery(monitor);
            monitor.subTask("Creating Menubar...");
            jave.startupMenuBar();
            monitor.subTask("Cleanup");
            jave.startupFinish2();
            monitor.subTask("Creating Tool Options Dialog");
            jave.startupOptionsDialog();
            monitor.subTask("That's it :-)");
            jave.startupFinish3();
            jave.getMainPanel().requestFocus();
            jave.getFrame().toFront();
            return;
        }
        catch (StartupException startupException) {
            StartupException e = startupException;
            throw startupException;
        }
        catch (Exception e) {
            if (jave != null) {
                jave.dispose();
            }
            throw new StartupException("An error has occured while trying to start JavE.", e);
        }
    }

    public static final void initConfigFiles(Component parentComponent) throws StartupException {
        JaveConfigurationFileLoader loader = new JaveConfigurationFileLoader(parentComponent);
        if (!loader.isConfigurationFolderExistant()) {
            throw new StartupException("The program is not installed correctly. If you have unzipped this software from a ZIP file you most probably have forgotten to check the option 'Use folder names' to keep the folder structure as it is in the ZIP file. Try reinstalling the software again.");
        }
        loader.initConfigFile(CharSetsConfiguration.getInstance());
        loader.initConfigFile(PixelPlateConfiguration.getInstance());
        loader.initConfigFile(CharacterPlateConfiguration.getInstance());
        loader.initConfigFile(GeneralAlgorithmConfiguration.getInstance());
        loader.initConfigFile(AsciiGradientConfiguration.getInstance());
        loader.initConfigFile(AsciiGreyscaleTableConfiguration.getInstance());
        loader.initConfigFile(AsciiReplaceIllegalConfiguration.getInstance());
        loader.initConfigFile(AsciiRepairAlgorithmConfiguration.getInstance());
        loader.initConfigFile(FigletConfiguration.getInstance());
    }
}

