/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.clipart;

import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.clipart.ClipartGroup;
import de.jave.lib.Toolbox;
import java.awt.Component;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.List;
import net.disy.commons.core.message.Message;
import net.disy.commons.swing.dialog.message.MessageDialogFactory;

public final class ClipartManager {
    private static final File BASE_FOLDER = new File(JaveGlobalRessources.codeBase, "clipart");
    private final List groups = new ArrayList();

    private ClipartManager() {
    }

    private void loadGroups() throws Exception {
        File f = BASE_FOLDER;
        if (!f.exists()) {
            throw new Exception("The folder " + f.getAbsolutePath() + " does not exist.");
        }
        File[] fl = f.listFiles(new FilenameFilter(this){

            public final boolean accept(File dir, String name) {
                return name.toLowerCase().endsWith(".jcf");
            }
        });
        for (int i = 0; i < fl.length; ++i) {
            ClipartGroup mg = ClipartGroup.load(fl[i]);
            this.groups.add(mg);
        }
    }

    public final String[] getGroupNames() {
        String[] groupNames = new String[this.groups.size()];
        for (int i = 0; i < groupNames.length; ++i) {
            groupNames[i] = ((ClipartGroup)this.groups.get(i)).getName();
        }
        Toolbox.quickSortIgnoreCase(groupNames);
        return groupNames;
    }

    public final boolean hasGroupName(String name) {
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!((ClipartGroup)this.groups.get(i)).getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public final ClipartGroup getGroup(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.groups.size(); ++i) {
            if (!name.equals(((ClipartGroup)this.groups.get(i)).getName())) continue;
            return (ClipartGroup)this.groups.get(i);
        }
        return null;
    }

    public final void performSave(Component parentComponent, ClipartGroup group) {
        group.performSave(parentComponent, BASE_FOLDER);
    }

    public static final ClipartManager performLoad(Component parentComponent) {
        ClipartManager manager = new ClipartManager();
        try {
            manager.loadGroups();
        }
        catch (Exception e) {
            MessageDialogFactory.showMessageDialog(parentComponent, new Message("Error loading Clipart files.", e));
            return null;
        }
        return manager;
    }
}

