/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.figlet;

import de.jave.figlet.engine.FigConversionJobProcessor;
import de.jave.figlet.engine.FigDriver;
import de.jave.figlet.engine.primitives.FigFont;
import de.jave.figlet.engine.processing.FigletJobFactory;
import de.jave.gui.GTextArea;
import de.jave.gui.dialog.GDialog;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.figlet.FigletConfiguration;
import de.jave.lib.job.AsynchronousDroppingJobProcessor;
import de.jave.lib.job.IResultConsumer;
import de.jave.lib.job.NullWarningCollector;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.util.Ensure;
import net.disy.commons.swing.action.SmartAction;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;
import net.disy.commons.swing.layout.util.ButtonPanelBuilder;

public final class FigletFontTestDialog {
    private final GTextArea taInput;
    private final GTextArea taOutput;
    private final JDialog dialog;
    private final FigDriver figDriver;
    private final AsynchronousDroppingJobProcessor processor;
    private final FigFont predefinedFont;

    public FigletFontTestDialog(Component parentComponent, String title, FigFont predefinedFont) {
        Ensure.ensureArgumentNotNull(predefinedFont);
        this.predefinedFont = predefinedFont;
        this.dialog = GDialog.createJDialog(parentComponent, title, true);
        this.dialog.getContentPane().setLayout(new BorderLayout());
        this.dialog.addWindowListener(new WindowAdapter(){

            public final void windowClosing(WindowEvent e) {
                FigletFontTestDialog.this.close();
            }

            public final void windowActivated(WindowEvent e) {
                FigletFontTestDialog.this.taInput.requestFocus();
            }
        });
        this.figDriver = FigletConfiguration.getInstance().getFigDriver();
        this.taOutput = new GTextArea(15, 80);
        this.taOutput.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.taOutput.setEditable(false);
        this.taInput = new GTextArea("Figlet", 5, 80);
        this.taInput.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                FigletFontTestDialog.this.figletize();
            }
        });
        this.taInput.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        JPanel p = new JPanel(new GridDialogLayout(1, false));
        p.add(new JLabel("Preview:"));
        p.add((Component)this.taOutput.getContent(), GridDialogLayoutData.FILL_BOTH);
        p.add(new JLabel("Text:"));
        p.add((Component)this.taInput.getContent(), GridDialogLayoutData.FILL_BOTH);
        this.dialog.getContentPane().add((Component)p, "Center");
        ButtonPanelBuilder buttonPanelBuilder = new ButtonPanelBuilder();
        SmartAction closeAction = new SmartAction("&Close"){

            protected final void execute(Component parentComponent) {
                FigletFontTestDialog.this.close();
            }
        };
        buttonPanelBuilder.add(closeAction);
        this.dialog.getContentPane().add((Component)buttonPanelBuilder.createPanel(), "South");
        FigConversionJobProcessor figProcessor = new FigConversionJobProcessor(this.figDriver, new IResultConsumer(){

            public final void putResult(Object o) {
                FigletFontTestDialog.this.taOutput.setText(String.valueOf(o));
            }
        }, new NullWarningCollector());
        this.processor = new AsynchronousDroppingJobProcessor(figProcessor);
        this.dialog.pack();
    }

    public final void setText(String text) {
        this.taInput.setText(text);
    }

    public final void show() {
        this.dialog.setVisible(true);
        if (this.taInput != null) {
            this.taInput.selectAll();
            this.taInput.requestFocus();
        }
    }

    private void figletize() {
        String text = this.taInput.getText();
        this.processor.startJob(FigletJobFactory.createJob(text, this.predefinedFont, this.predefinedFont.getLayout()));
    }

    private void close() {
        this.dialog.setVisible(false);
    }
}

