/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.figlet.export;

import de.jave.gui.FilenameTextField;
import de.jave.gui.GTextArea;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.figlet.export.AbstractFigletExportWizardPage;
import de.jave.jave.figlet.export.FigletExportModel;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.message.BasicMessage;
import net.disy.commons.core.message.IBasicMessage;
import net.disy.commons.core.message.MessageType;
import net.disy.commons.swing.events.AbstractDocumentChangeListener;
import net.disy.commons.swing.layout.grid.EndOfLineMarkerComponent;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class FigletExportWizardPage5
extends AbstractFigletExportWizardPage {
    private GTextArea taComments;
    private FilenameTextField tfFilename;

    public FigletExportWizardPage5(FigletExportModel model) {
        super(model, "Font Name and Comments", (IBasicMessage)new BasicMessage("Specify a good name for the new font. Also please add some comments, to let everybody know who created this font."));
    }

    protected final IBasicMessage createCurrentMessage() {
        if (this.getModel().getName().length() == 0) {
            return new BasicMessage("The font name is empty. Please specify a name.", MessageType.ERROR);
        }
        if (this.getModel().getName().length() < 4) {
            return new BasicMessage("The font name is discouraged. Font names should be at leat 4 characters long.", MessageType.WARNING);
        }
        if (this.getModel().getName().length() > 30) {
            return new BasicMessage("The font name is discouraged. Font names should not be too long.", MessageType.WARNING);
        }
        if (FigletExportWizardPage5.containsUpperCaseLetters(this.getModel().getName())) {
            return new BasicMessage("The font name is discouraged. By convention font names should not contain uppercase letters.", MessageType.WARNING);
        }
        return this.getDefaultMessage();
    }

    private static boolean containsUpperCaseLetters(String name) {
        for (int i = 0; i < name.length(); ++i) {
            if (!Character.isUpperCase(name.charAt(i))) continue;
            return true;
        }
        return false;
    }

    protected final JComponent createContent() {
        this.taComments = new GTextArea(this.getModel().getComment(), 12, 60);
        this.taComments.setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
        this.tfFilename = new FilenameTextField(this.getModel().getName(), 12);
        JPanel panel = new JPanel(new GridDialogLayout(3, false));
        panel.add(new JLabel("Font Name:"));
        panel.add((Component)this.tfFilename, GridDialogLayoutData.FILL_HORIZONTAL);
        panel.add(new JLabel(".flf"));
        panel.add(new JLabel("Comments:"));
        panel.add(new EndOfLineMarkerComponent());
        GridDialogLayoutData data = new GridDialogLayoutData(GridDialogLayoutData.FILL_BOTH);
        data.setHorizontalSpan(3);
        panel.add((Component)this.taComments.getContent(), data);
        this.getModel().addChangeListener(this.getCheckInputValidListener());
        this.taComments.addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                FigletExportWizardPage5.this.getModel().setComment(FigletExportWizardPage5.this.taComments.getText());
            }
        });
        this.tfFilename.getDocument().addDocumentListener(new AbstractDocumentChangeListener(){

            protected final void documentChanged() {
                FigletExportWizardPage5.this.getModel().setName(FigletExportWizardPage5.this.tfFilename.getText());
            }
        });
        return panel;
    }

    public final boolean canFinish() {
        return this.getModel().canFinish();
    }

    public final void requestFocus() {
        this.tfFilename.requestFocus();
    }
}

