/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.pixelplate;

import de.jave.gui.GButton;
import de.jave.gui.GButtonGroup;
import de.jave.gui.GTextButton;
import de.jave.gui.GVLine;
import de.jave.jave.JaveGlobalRessources;
import de.jave.jave.JaveImages;
import de.jave.jave.MixCharactersPanel;
import de.jave.jave.pixelplate.PixelPlate;
import de.jave.jave.pixelplate.PixelPlateFeltPenMode;
import de.jave.jave.pixelplate.PixelPlateMode;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import net.disy.commons.core.model.BooleanModel;
import net.disy.commons.swing.layout.grid.GridDialogLayout;
import net.disy.commons.swing.layout.grid.GridDialogLayoutData;

public final class PixelPlateOptionsPanel
extends JPanel {
    private GButtonGroup sizeButtonGroup;
    private GButtonGroup styleButtonGroup;
    private static double[] CURSOR_DIAMETER = new double[]{1.9, 2.5, 3.2, 4.0};

    public PixelPlateOptionsPanel(BooleanModel mixCharactersModel) {
        JPanel pSize = new JPanel();
        pSize.setLayout(new FlowLayout(1, 0, 2));
        this.sizeButtonGroup = new GButtonGroup();
        GButton bs0 = JaveImages.createButton("pencil/roundsize1.gif", "pencil/roundsize1_.gif");
        bs0.setToggleButton(true);
        this.sizeButtonGroup.add(bs0);
        pSize.add(bs0);
        pSize.add(new GVLine(4, 22));
        GButton bs1 = JaveImages.createButton("pencil/roundsize4.gif", "pencil/roundsize4_.gif");
        bs1.setToggleButton(true);
        this.sizeButtonGroup.add(bs1);
        pSize.add(bs1);
        GButton bs2 = JaveImages.createButton("pencil/roundsize5.gif", "pencil/roundsize5_.gif");
        bs2.setToggleButton(true);
        this.sizeButtonGroup.add(bs2);
        pSize.add(bs2);
        GButton bs3 = JaveImages.createButton("pencil/roundsize6.gif", "pencil/roundsize6_.gif");
        bs3.setToggleButton(true);
        this.sizeButtonGroup.add(bs3);
        pSize.add(bs3);
        GButton bs4 = JaveImages.createButton("pencil/roundsize7.gif", "pencil/roundsize7_.gif");
        bs4.setToggleButton(true);
        this.sizeButtonGroup.add(bs4);
        pSize.add(bs4);
        bs0.set3DMode(1);
        bs1.set3DMode(1);
        bs2.set3DMode(1);
        bs3.set3DMode(1);
        bs4.set3DMode(1);
        this.sizeButtonGroup.select(0);
        JPanel pStyle = new JPanel(new FlowLayout(1, 0, 2));
        this.styleButtonGroup = new GButtonGroup();
        String[] styles = PixelPlate.FELTPEN_CHARS;
        Dimension styleButtonSize = new Dimension(16, 19);
        for (int i = 0; i < styles.length; ++i) {
            GTextButton b = new GTextButton(styles[i]);
            b.setToggleButton(true);
            b.setFocusTraversable(false);
            b.setPreferredSize(styleButtonSize);
            b.set3DMode(1);
            ((JComponent)b).setFont(JaveGlobalRessources.FONT_SMALL_FIXEDWIDTH);
            this.styleButtonGroup.add(b);
            pStyle.add(b);
        }
        this.styleButtonGroup.select(4);
        this.setLayout(new GridDialogLayout(1, false));
        this.add((Component)pSize, GridDialogLayoutData.FILL_HORIZONTAL);
        this.add((Component)pStyle, GridDialogLayoutData.FILL_HORIZONTAL);
        this.add((Component)new MixCharactersPanel(mixCharactersModel).getContent(), GridDialogLayoutData.FILL_HORIZONTAL);
    }

    public final boolean isFeltpenMode() {
        return this.sizeButtonGroup.getSelectedIndex() > 0;
    }

    public final boolean isLineMode() {
        return this.sizeButtonGroup.getSelectedIndex() == 0;
    }

    public final double getFeltpenPreviewDiameter() {
        return CURSOR_DIAMETER[this.sizeButtonGroup.getSelectedIndex() - 1];
    }

    public final void configure(PixelPlate pixelPlate) {
        int size = this.sizeButtonGroup.getSelectedIndex();
        int feltPenSize = this.sizeButtonGroup.getSelectedIndex();
        char feltPenChar = PixelPlate.FELTPEN_CHARS[this.styleButtonGroup.getSelectedIndex()].charAt(0);
        if (size == 0) {
            if (feltPenChar == ':') {
                pixelPlate.setMode(PixelPlateMode.DOT);
                return;
            }
            pixelPlate.setMode(PixelPlateMode.PIXEL);
            return;
        }
        pixelPlate.setMode(new PixelPlateFeltPenMode(feltPenChar, feltPenSize));
    }
}

