/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.plate;

import de.jave.asciimation.editor.AnimationEditorModel;
import de.jave.asciimation.editor.AnimationEditorPanel;
import de.jave.jave.DocumentListener;
import de.jave.jave.Jave;
import de.jave.jave.Plate;
import de.jave.jave.PlateDocument;
import de.jave.jave.browser.JaveDocumentType;
import de.jave.jave.plate.AbstractDocumentEditor;
import de.jave.jave.plate.ToolManager;
import de.jave.jave.preferences.AnimationExportPreferences;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.preferences.JaveApplicationPreferences;
import de.jave.jave.preferences.PlatePreferences;
import de.jave.javeplayer.JaveAnimationFile;
import de.jave.lib.CharacterPlate;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.disy.commons.core.io.FileModel;
import net.disy.commons.core.util.Ensure;

public final class AnimationDocumentEditor
extends AbstractDocumentEditor {
    private final Plate plate;
    private final JComponent content;
    private final AnimationEditorPanel animationEditorPanel;
    private final String stopGapName;

    public AnimationDocumentEditor(String stopGapName, JaveAnimationFile animationFile, Jave jave, final PlateDocument document, PlatePreferences platePreferences, JaveApplicationPreferences preferences, ToolManager toolManager, AnimationExportPreferences animationExportPreferences, FileModel currentDirectoryModel) {
        Ensure.ensureArgumentNotNull(stopGapName);
        Ensure.ensureArgumentNotNull(animationFile);
        Ensure.ensureArgumentNotNull(jave);
        Ensure.ensureArgumentNotNull(platePreferences);
        Ensure.ensureArgumentNotNull(toolManager);
        Ensure.ensureArgumentNotNull(currentDirectoryModel);
        this.stopGapName = stopGapName;
        document.setFile(animationFile.getFile());
        if (animationFile.getFrameCount() > 0) {
            document.setContent(new CharacterPlate(animationFile.getFrame(0).getContent()));
        }
        document.setColorScheme(ColorScheme.BLACK_ON_WHITE);
        this.plate = new Plate(document, jave, platePreferences, toolManager, preferences.getDisplayFontModel());
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.plate.getComponent(), "Center");
        AnimationEditorModel model = new AnimationEditorModel();
        model.setAnimationFile(animationFile);
        this.animationEditorPanel = new AnimationEditorPanel(model, currentDirectoryModel, this.plate, preferences, animationExportPreferences);
        panel.add((Component)this.animationEditorPanel.getContent(), "South");
        this.content = panel;
        this.animationEditorPanel.getCurrentFrameIndexModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AnimationDocumentEditor.this.updatePlateContent();
            }
        });
        this.animationEditorPanel.getModel().addChangeListener(new ChangeListener(){

            public final void stateChanged(ChangeEvent e) {
                AnimationDocumentEditor.this.updatePlateContent();
            }
        });
        document.addDocumentListener(new DocumentListener(){

            public final void documentChanged() {
                AnimationDocumentEditor.this.animationEditorPanel.getModel().setCurrentFrameContent(document.getContent());
            }

            public final void documentShowing() {
            }

            public final void documentHiding() {
            }

            public final void documentClosing() {
            }
        });
    }

    private void updatePlateContent() {
        JaveAnimationFile animationFile = this.animationEditorPanel.getModel().getAnimationFile();
        int currentFrameIndex = this.animationEditorPanel.getCurrentFrameIndexModel().getCurrentFrameIndex();
        this.plate.setContent(new CharacterPlate(animationFile.getFrame(currentFrameIndex).getContent()));
    }

    public final AnimationEditorPanel getAnimationEditorPanel() {
        return this.animationEditorPanel;
    }

    public final Plate getPlate() {
        return this.plate;
    }

    public final JComponent getContent() {
        return this.content;
    }

    public final JaveDocumentType getType() {
        return JaveDocumentType.ANIMATION;
    }

    public final AnimationEditorModel getModel() {
        return this.animationEditorPanel.getModel();
    }

    public final boolean isModified() {
        return this.getModel().isModified();
    }

    public final File getFile() {
        return this.getModel().getAnimationFile().getFile();
    }

    public final String getStopGapName() {
        return this.stopGapName;
    }
}

