/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.preferences;

import de.jave.jave.application.resources.JaveImageProvider;
import java.awt.Color;
import javax.swing.Icon;

public final class ColorScheme {
    private final String name;
    private static final Color DARK_YELLOW = new Color(192, 192, 0);
    private static final Color GRAY_128 = new Color(128, 128, 128);
    private static final Color[] COLOR_CURSOR = new Color[]{Color.black, Color.white, Color.black};
    private static final Color[] COLOR_TOOL_REGION = new Color[]{Color.blue, Color.blue, Color.blue};
    private static final Color[] COLOR_TOOL = new Color[]{Color.gray, Color.darkGray, Color.gray};
    private static final Color[] COLOR_TOOL_DARKER = new Color[]{DARK_YELLOW, DARK_YELLOW, DARK_YELLOW};
    private static final Color[] COLOR_PLATE_SHADOW = new Color[]{Color.black, Color.darkGray, Color.black};
    private static final Color[] COLOR_TOOL_PREVIEW = new Color[]{new Color(0, 0, 160), new Color(160, 160, 255), new Color(0, 0, 192)};
    private static final Color[] COLOR_TOOL_PREVIEW_DELETE = new Color[]{new Color(160, 160, 255), new Color(0, 0, 192), new Color(160, 160, 255)};
    private static final Color[] COLOR_TOOL_HELPING = new Color[]{new Color(96, 96, 96), new Color(128, 128, 128), new Color(160, 160, 160)};
    private static final Color[] COLOR_WATERMARK = new Color[]{new Color(0, 0, 192), new Color(0, 0, 192), new Color(0, 0, 192)};
    private static final Color[] COLOR_WATERMARK_FILL = new Color[]{new Color(192, 192, 255), new Color(192, 192, 255), new Color(192, 192, 255)};
    private static final Color[] COLOR_SELECTION_TEXT = new Color[]{Color.gray, Color.gray, Color.gray};
    private static final Color[] COLOR_PLATE_LINES = new Color[]{new Color(224, 224, 224), new Color(32, 32, 32), new Color(178, 178, 178)};
    private static final Color[] COLOR_PLATE_EMPTY = new Color[]{GRAY_128, GRAY_128, GRAY_128};
    private static final Color[] COLOR_SELECTION_BACKGROUND = new Color[]{new Color(230, 230, 230), new Color(32, 32, 32), new Color(205, 205, 205)};
    private static final Color[] COLOR_PLATE_BACKGROUND = new Color[]{Color.white, Color.black, new Color(192, 192, 192)};
    private static final Color[] COLOR_TEXT = new Color[]{Color.black, Color.white, Color.black};
    private static final String[] COLOR_SCHEME_HEX = new String[]{"#FFFFFF #000000", "#000000 #FFFFFF", "#C0C0C0 #000000"};
    private final Color colorSelectionBackground;
    private final Color colorSelectionText;
    private final Color colorPlateEmpty;
    private final Color colorPlateShadow;
    private final Color colorPlateBackground;
    private final Color colorPlateLines;
    private final Color colorText;
    private final Color colorCursor;
    private final Color colorToolHelping;
    private final Color colorToolPreview;
    private final Color colorToolPreviewDelete;
    private final Color colorToolRegion;
    private final Color colorTool;
    private final Color colorToolDarker;
    private final Color colorWatermarkFill;
    private final Color colorWatermark;
    private final String colorHex;
    public static final ColorScheme BLACK_ON_WHITE = new ColorScheme("black on white", 0, JaveImageProvider.getInstance().getImageIcon("color/color_black_on_white.gif"));
    public static final ColorScheme WHITE_ON_BLACK = new ColorScheme("white on black", 1, JaveImageProvider.getInstance().getImageIcon("color/color_white_on_black.gif"));
    public static final ColorScheme BLACK_ON_GRAY = new ColorScheme("black on gray", 2, JaveImageProvider.getInstance().getImageIcon("color/color_black_on_gray.gif"));
    private final Icon icon;

    public ColorScheme(String name, int index, Icon icon) {
        this.name = name;
        this.icon = icon;
        this.colorSelectionBackground = COLOR_SELECTION_BACKGROUND[index];
        this.colorSelectionText = COLOR_SELECTION_TEXT[index];
        this.colorPlateLines = COLOR_PLATE_LINES[index];
        this.colorPlateEmpty = COLOR_PLATE_EMPTY[index];
        this.colorPlateBackground = COLOR_PLATE_BACKGROUND[index];
        this.colorPlateShadow = COLOR_PLATE_SHADOW[index];
        this.colorText = COLOR_TEXT[index];
        this.colorCursor = COLOR_CURSOR[index];
        this.colorToolHelping = COLOR_TOOL_HELPING[index];
        this.colorToolPreview = COLOR_TOOL_PREVIEW[index];
        this.colorToolPreviewDelete = COLOR_TOOL_PREVIEW_DELETE[index];
        this.colorToolRegion = COLOR_TOOL_REGION[index];
        this.colorTool = COLOR_TOOL[index];
        this.colorToolDarker = COLOR_TOOL_DARKER[index];
        this.colorWatermarkFill = COLOR_WATERMARK_FILL[index];
        this.colorWatermark = COLOR_WATERMARK[index];
        this.colorHex = COLOR_SCHEME_HEX[index];
    }

    public final Icon getIcon() {
        return this.icon;
    }

    public final String getName() {
        return this.name;
    }

    public final Color getColorCursor() {
        return this.colorCursor;
    }

    public final Color getColorPlateBackground() {
        return this.colorPlateBackground;
    }

    public final Color getColorPlateEmpty() {
        return this.colorPlateEmpty;
    }

    public final Color getColorPlateLines() {
        return this.colorPlateLines;
    }

    public final Color getColorPlateShadow() {
        return this.colorPlateShadow;
    }

    public final Color getColorSelectionBackground() {
        return this.colorSelectionBackground;
    }

    public final Color getColorSelectionText() {
        return this.colorSelectionText;
    }

    public final Color getColorText() {
        return this.colorText;
    }

    public final Color getColorTool() {
        return this.colorTool;
    }

    public final Color getColorToolDarker() {
        return this.colorToolDarker;
    }

    public final Color getColorToolHelping() {
        return this.colorToolHelping;
    }

    public final Color getColorToolPreview() {
        return this.colorToolPreview;
    }

    public final Color getColorToolPreviewDelete() {
        return this.colorToolPreviewDelete;
    }

    public final Color getColorToolRegion() {
        return this.colorToolRegion;
    }

    public final Color getColorWatermark() {
        return this.colorWatermark;
    }

    public final Color getColorWatermarkFill() {
        return this.colorWatermarkFill;
    }

    public final String getColorHex() {
        return this.colorHex;
    }

    public static final ColorScheme[] getAll() {
        return new ColorScheme[]{BLACK_ON_WHITE, WHITE_ON_BLACK, BLACK_ON_GRAY};
    }
}

