/*
 * Decompiled with CFR 0.152.
 */
package de.jave.jave.tool.fill;

import de.jave.gfx.GfxTools;
import de.jave.jave.Jave;
import de.jave.jave.Tool;
import de.jave.jave.algorithm.fill.FillAlgorithm;
import de.jave.jave.algorithm.fill.FillMatchMode;
import de.jave.jave.algorithm.fill.FillMode;
import de.jave.jave.algorithm.fill.GradientStyle;
import de.jave.jave.application.resources.JaveImageProvider;
import de.jave.jave.pattern.Pattern;
import de.jave.jave.plate.JaveMainPanel;
import de.jave.jave.preferences.ColorScheme;
import de.jave.jave.tool.fill.FillOptions;
import de.jave.jave.tool.fill.FillOptionsPanel;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import net.disy.commons.swing.mousecursor.CursorId;
import net.disy.commons.swing.mousecursor.CursorProvider;

public final class FillTool
extends Tool {
    private Point location1;
    private Point point1;
    private Point location2;
    private Point point2;
    private final FillOptions options = new FillOptions();

    public FillTool(JaveMainPanel plate, Jave asciiPainter) {
        super(plate, asciiPainter);
    }

    public final JComponent createOptionsComponent() {
        return new FillOptionsPanel(this.options, this.getMouseCharacterModel()).getContent();
    }

    private FillMode getCurrentMode() {
        return this.options.getFillMode();
    }

    private char[] getGradient() {
        return this.options.getGradient(metaDown);
    }

    public final String getName() {
        return "Fill";
    }

    public final Icon getIcon() {
        return JaveImageProvider.getInstance().getImageIcon("tool/fill.gif");
    }

    public final void takeToHand() {
        this.setCursor(CursorProvider.getInstance().getCursor(CursorId.CROSSHAIR_SELECTION));
    }

    public final void putAside(boolean nextToolIsSelectionTool) {
    }

    public final void mousePressed(Point point, Point location, MouseEvent evt) {
        if (location == null) {
            return;
        }
        FillMode mode = this.getCurrentMode();
        if (mode == FillMode.SOLID) {
            FillMatchMode matchMode = this.options.getMatchMode();
            this.setMixMode(false);
            FillAlgorithm.fillSolid(this.getPlate().getContent(), location.x, location.y, this.getMouseChar(), matchMode);
            this.getPlate().saveCurrentState("fill solid");
            this.repaintAll();
            return;
        }
        if (mode == FillMode.PATTERN) {
            FillMatchMode matchMode = this.options.getMatchMode();
            Pattern pattern = this.options.getPattern();
            this.setMixMode(false);
            FillAlgorithm.fillPattern(this.getPlate().getContent(), location.x, location.y, pattern, matchMode);
            this.getPlate().saveCurrentState("fill pattern");
            this.repaintAll();
            return;
        }
        if (mode == FillMode.GRADIENT && this.options.getGradientStyle() == GradientStyle.SUNBURST) {
            FillMatchMode matchMode = this.options.getMatchMode();
            char[] ch = this.getGradient();
            this.setMixMode(false);
            FillAlgorithm.fillGradient(this.getPlate().getContent(), location.x, location.y, location.x, location.y, ch, GradientStyle.SUNBURST, matchMode, this.options.isDither());
            this.getPlate().saveCurrentState("fill gradient");
            this.repaintAll();
            return;
        }
        if (mode == FillMode.GRADIENT) {
            this.location1 = location;
            this.point1 = point;
            this.point2 = point;
            this.repaintCursor();
        }
    }

    public final void mouseDragged(Point point, Point location, MouseEvent evt) {
        if (this.getCurrentMode() == FillMode.GRADIENT) {
            this.location2 = location;
            this.point2 = point;
            this.repaintCursor();
        }
    }

    public final void mouseReleased(Point point, Point location, MouseEvent evt) {
        if (this.getCurrentMode() == FillMode.GRADIENT || this.options.getGradientStyle() != GradientStyle.SUNBURST) {
            this.location2 = location;
            if (location == null || this.location1 == null || this.location1.equals(this.location2)) {
                this.location1 = null;
                this.repaintCursor();
                return;
            }
            GradientStyle style = this.options.getGradientStyle();
            FillMatchMode matchMode = this.options.getMatchMode();
            char[] ch = this.getGradient();
            this.setMixMode(false);
            FillAlgorithm.fillGradient(this.getPlate().getContent(), this.location1.x, this.location1.y, this.location2.x, this.location2.y, ch, style, matchMode, this.options.isDither());
            this.location1 = null;
            this.location2 = null;
            this.point1 = null;
            this.point2 = null;
            this.getPlate().saveCurrentState("fill gradient");
            this.repaintAll();
        }
    }

    public final void keyPressed(int code, KeyEvent evt) {
        if (this.location1 == null || this.location2 == null) {
            return;
        }
        if (code == 27) {
            this.point1 = null;
            this.point2 = null;
            this.location1 = null;
            this.location2 = null;
            this.repaintCursor();
            return;
        }
    }

    public final void paintCursorFeature(Graphics2D g, Point plateOrigin, ColorScheme colorScheme) {
        if (this.location1 == null || this.location2 == null || this.point1 == null || this.point2 == null) {
            return;
        }
        g.setColor(colorScheme.getColorToolHelping());
        Point p1 = this.getScreenPointFor(this.location1.x, this.location1.y);
        g.drawLine(p1.x + this.getPlate().getCharWidth() / 2, p1.y + this.getPlate().getCharHeight() / 2, this.point2.x, this.point2.y);
        GfxTools.paintArrow(g, p1.x + this.getPlate().getCharWidth() / 2, p1.y + this.getPlate().getCharHeight() / 2, this.point2.x, this.point2.y);
    }
}

